/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExpressionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ShowExpressionTypeHandler
implements CodeInsightActionHandler {
    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, final @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler", "invoke"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(project2, language, file2.getViewProvider().getBaseLanguage());
        if (handlers.isEmpty()) {
            return;
        }
        boolean exactRange = false;
        TextRange range = EditorUtil.getSelectionInAnyMode(editor);
        final LinkedHashMap map2 = ContainerUtil.newLinkedHashMap();
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        for (int i2 = 0; i2 < 3 && map2.isEmpty() && offset > i2; ++i2) {
            PsiElement elementAt = file2.findElementAt(offset - i2);
            if (elementAt == null) continue;
            for (ExpressionTypeProvider handler2 : handlers) {
                for (PsiElement element : handler2.getExpressionsAt(elementAt)) {
                    TextRange r = element.getTextRange();
                    if (exactRange && !r.equals((Object)range) || !r.contains(range)) continue;
                    if (!exactRange) {
                        exactRange = r.equals((Object)range);
                    }
                    map2.put(element, handler2);
                }
            }
        }
        Pass<PsiElement> callback = new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$1", "pass"));
                }
                ExpressionTypeProvider provider = (ExpressionTypeProvider)ObjectUtils.assertNotNull(map2.get(expression2));
                String informationHint = provider.getInformationHint(expression2);
                TextRange range = expression2.getTextRange();
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$1", "lambda$pass$0"));
                    }
                    HintManager.getInstance().showInformationHint(editor, informationHint);
                });
            }
        };
        if (map2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler", "lambda$invoke$0"));
                }
                String errorHint = ((ExpressionTypeProvider)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)handlers))).getErrorHint();
                HintManager.getInstance().showErrorHint(editor, errorHint);
            });
        } else if (map2.size() == 1) {
            callback.pass(ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(map2.keySet())));
        } else {
            IntroduceTargetChooser.showChooser(editor, ContainerUtil.newArrayList(map2.keySet()), callback, expression2 -> expression2.getText());
        }
    }

    @NotNull
    public static Set<ExpressionTypeProvider> getHandlers(Project project2, Language ... languages) {
        Set set2 = (Set)JBIterable.of((Object[])languages).flatten(language -> DumbService.getInstance((Project)project2).filterByDumbAwareness((Collection)LanguageExpressionTypes.INSTANCE.allForLanguage(language))).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler", "getHandlers"));
        }
        return set2;
    }
}

