/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoContext
implements CreateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private final int myOffset;
    private final int myParameterListStart;
    private PsiElement myHighlightedElement;
    private Object[] myItems;
    private boolean myRequestFocus;

    public ShowParameterInfoContext(Editor editor, Project project2, PsiFile file2, int offset, int parameterListStart) {
        this(editor, project2, file2, offset, parameterListStart, false);
    }

    public ShowParameterInfoContext(Editor editor, Project project2, PsiFile file2, int offset, int parameterListStart, boolean requestFocus) {
        this.myEditor = editor;
        this.myProject = project2;
        this.myFile = file2;
        this.myParameterListStart = parameterListStart;
        this.myOffset = offset;
        this.myRequestFocus = requestFocus;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getParameterListStart() {
        return this.myParameterListStart;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext", "getEditor"));
        }
        return editor;
    }

    public PsiElement getHighlightedElement() {
        return this.myHighlightedElement;
    }

    public void setHighlightedElement(PsiElement element) {
        this.myHighlightedElement = element;
    }

    public void setItemsToShow(Object[] items) {
        this.myItems = items;
    }

    public Object[] getItemsToShow() {
        return this.myItems;
    }

    public void showHint(PsiElement element, int offset, ParameterInfoHandler handler2) {
        Object[] itemsToShow = this.getItemsToShow();
        if (itemsToShow == null || itemsToShow.length == 0) {
            return;
        }
        ShowParameterInfoContext.showMethodInfo(this.getProject(), this.getEditor(), element, this.getHighlightedElement(), itemsToShow, offset, handler2, this.myRequestFocus);
    }

    private static void showParameterHint(PsiElement element, Editor editor, Object[] descriptors, Project project2, @Nullable PsiElement highlighted, int elementStart, ParameterInfoHandler handler2, boolean requestFocus) {
        if (ParameterInfoController.isAlreadyShown(editor, elementStart)) {
            return;
        }
        if (editor.isDisposed() || !editor.getComponent().isVisible()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).performLaterWhenAllCommitted(() -> {
            if (editor.isDisposed() || DumbService.isDumb((Project)project2) || !editor.getComponent().isShowing()) {
                return;
            }
            Document document = editor.getDocument();
            if (document.getTextLength() < elementStart) {
                return;
            }
            ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, elementStart);
            if (controller == null) {
                new ParameterInfoController(project2, editor, elementStart, descriptors, highlighted, element, handler2, true, requestFocus);
            } else {
                controller.showHint(requestFocus);
            }
        });
    }

    private static void showMethodInfo(Project project2, Editor editor, PsiElement list2, PsiElement highlighted, Object[] candidates, int offset, ParameterInfoHandler handler2, boolean requestFocus) {
        ShowParameterInfoContext.showParameterHint(list2, editor, candidates, project2, (PsiElement)(candidates.length > 1 ? highlighted : null), offset, handler2, requestFocus);
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }
}

