/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<String> myHints;
    private final TIntObjectHashMap<String> myShowOnlyIfExistedBeforeHints;
    private final SyntaxTraverser<PsiElement> myTraverser;
    private final PsiElement myRootElement;

    public ParameterHintsPass(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/hints/ParameterHintsPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPass", "<init>"));
        }
        super(editor, element.getContainingFile(), true);
        this.myHints = new TIntObjectHashMap();
        this.myShowOnlyIfExistedBeforeHints = new TIntObjectHashMap();
        this.myRootElement = element;
        this.myTraverser = SyntaxTraverser.psiTraverser((PsiElement)element);
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/hints/ParameterHintsPass", "doCollectInformation"));
        }
        assert (this.myDocument != null);
        this.myHints.clear();
        if (!ParameterHintsPass.isEnabled()) {
            return;
        }
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null) {
            return;
        }
        List<Matcher> matchers = ParameterHintsPass.getBlackListMatchers(language);
        this.myTraverser.forEach(element -> this.process((PsiElement)element, provider, matchers));
    }

    public static List<Matcher> getBlackListMatchers(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Set<String> blackList = ParameterHintsPass.getBlackList(language);
        Language dependentLanguage = provider.getBlackListDependencyLanguage();
        if (dependentLanguage != null) {
            blackList.addAll(ParameterHintsPass.getBlackList(dependentLanguage));
        }
        return blackList.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher((String)item)).filter(e -> e != null).collect(Collectors.toList());
    }

    public static Set<String> getBlackList(Language language) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider != null) {
            ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
            Diff diff = settings.getBlackListDiff(language);
            return diff.applyOn(provider.getDefaultBlackList());
        }
        return ContainerUtil.newHashOrEmptySet((Iterable)ContainerUtil.emptyIterable());
    }

    private static boolean isEnabled() {
        return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
    }

    private static boolean isMatchedByAny(HintInfo info, List<Matcher> matchers) {
        if (info instanceof HintInfo.MethodInfo) {
            HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)info;
            return matchers.stream().anyMatch(e -> e.isMatching(methodInfo.getFullyQualifiedName(), methodInfo.getParamNames()));
        }
        return false;
    }

    private void process(PsiElement element, InlayParameterHintsProvider provider, List<Matcher> blackListMatchers) {
        List hints = provider.getParameterHints(element);
        if (hints.isEmpty()) {
            return;
        }
        HintInfo info = provider.getHintInfo(element);
        if (info == null || !ParameterHintsPass.isMatchedByAny(info, blackListMatchers)) {
            hints.forEach(hint -> {
                String presentation = provider.getInlayPresentation(hint.getText());
                int offset = hint.getOffset();
                if (hint.isShowOnlyIfExistedBefore()) {
                    this.myShowOnlyIfExistedBeforeHints.put(offset, (Object)presentation);
                } else {
                    this.myHints.put(offset, (Object)presentation);
                }
            });
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
        ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
        List<Inlay> hints = this.hintsInRootElementArea(manager);
        ParameterHintsUpdater updater = new ParameterHintsUpdater(this.myEditor, hints, this.myHints, this.myShowOnlyIfExistedBeforeHints);
        updater.update();
        keeper.restoreOriginalLocation(false);
        ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
    }

    @NotNull
    private List<Inlay> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        assert (this.myDocument != null);
        TextRange range = this.myRootElement.getTextRange();
        int elementStart = range.getStartOffset();
        int elementEnd = range.getEndOffset();
        List inlays = this.myEditor.getInlayModel().getInlineElementsInRange(elementStart, elementEnd);
        List list2 = ContainerUtil.filter((Collection)inlays, hint -> manager.isParameterHint((Inlay)hint));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hints/ParameterHintsPass", "hintsInRootElementArea"));
        }
        return list2;
    }
}

