/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    protected static final Key<Long> PSI_MODIFICATION_STAMP = Key.create((String)"psi.modification.stamp");

    public ParameterHintsPassFactory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
        super(project2);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        long currentStamp = ParameterHintsPassFactory.getCurrentModificationStamp(file2);
        Long savedStamp = (Long)editor.getUserData(PSI_MODIFICATION_STAMP);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        return new ParameterHintsPass((PsiElement)file2, editor);
    }

    public static long getCurrentModificationStamp(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "getCurrentModificationStamp"));
        }
        return file2.getManager().getModificationTracker().getModificationCount();
    }

    public static void forceHintsUpdateOnNextPass() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(editor);
        }
    }

    public static void forceHintsUpdateOnNextPass(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "forceHintsUpdateOnNextPass"));
        }
        editor.putUserData(PSI_MODIFICATION_STAMP, null);
    }

    protected static void putCurrentPsiModificationStamp(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "putCurrentPsiModificationStamp"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/hints/ParameterHintsPassFactory", "putCurrentPsiModificationStamp"));
        }
        editor.putUserData(PSI_MODIFICATION_STAMP, (Object)ParameterHintsPassFactory.getCurrentModificationStamp(file2));
    }
}

