/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class AddAnnotationIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/AddAnnotationIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public abstract Pair<String, String[]> getAnnotations(@NotNull Project var1);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddAnnotationIntention", "isAvailable"));
        }
        PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner2 == null || owner2.getModifierList() == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner2)) {
            return false;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project2);
        String toAdd = (String)annotations2.first;
        String[] toRemove2 = (String[])annotations2.second;
        if (toRemove2.length > 0 && AddAnnotationIntention.isAnnotatedSkipInferred(owner2, toRemove2)) {
            return false;
        }
        this.setText(AddAnnotationPsiFix.calcText(owner2, toAdd));
        if (AddAnnotationIntention.isAnnotatedSkipInferred(owner2, toAdd)) {
            return false;
        }
        return this.canAnnotate(owner2);
    }

    protected boolean canAnnotate(@NotNull PsiModifierListOwner owner2) {
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/intention/impl/AddAnnotationIntention", "canAnnotate"));
        }
        return true;
    }

    private static boolean isAnnotatedSkipInferred(PsiModifierListOwner owner2, String ... annoFqns) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (boolean)false, (String[])annoFqns);
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/AddAnnotationIntention", "invoke"));
        }
        PsiModifierListOwner owner2 = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner2 == null || !owner2.isValid()) {
            return;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project2);
        String toAdd = (String)annotations2.first;
        String[] toRemove2 = (String[])annotations2.second;
        AddAnnotationFix fix = new AddAnnotationFix(toAdd, owner2, toRemove2);
        fix.invoke(project2, editor, file2);
    }
}

