/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveInitializerToMethodAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "isAvailable"));
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class, PsiDocComment.class});
        if (field == null || this.hasUnsuitableModifiers(field)) {
            return false;
        }
        if (!field.hasInitializer()) {
            return false;
        }
        PsiClass psiClass = field.getContainingClass();
        return psiClass != null && !psiClass.isInterface() && !(psiClass instanceof PsiAnonymousClass) && !(psiClass instanceof PsiSyntheticClass);
    }

    private boolean hasUnsuitableModifiers(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "hasUnsuitableModifiers"));
        }
        for (String modifier : this.getUnsuitableModifiers()) {
            if (!field.hasModifierProperty(modifier)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected abstract Collection<String> getUnsuitableModifiers();

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "invoke"));
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        assert (field != null);
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return;
        }
        Collection<PsiMethod> methodsToAddInitialization = this.getOrCreateMethods(project2, editor, element.getContainingFile(), aClass);
        if (methodsToAddInitialization.isEmpty()) {
            return;
        }
        List<PsiExpressionStatement> assignments = BaseMoveInitializerToMethodAction.addFieldAssignments(field, methodsToAddInitialization);
        field.getInitializer().delete();
        if (!assignments.isEmpty()) {
            BaseMoveInitializerToMethodAction.highlightRExpression((PsiAssignmentExpression)assignments.get(0).getExpression(), project2, editor);
        }
    }

    private static void highlightRExpression(@NotNull PsiAssignmentExpression assignment, @NotNull Project project2, Editor editor) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "highlightRExpression"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "highlightRExpression"));
        }
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiExpression expression2 = assignment.getRExpression();
        HighlightManager.getInstance((Project)project2).addOccurrenceHighlights(editor, new PsiElement[]{expression2}, attributes, false, null);
    }

    @NotNull
    private static List<PsiExpressionStatement> addFieldAssignments(@NotNull PsiField field, @NotNull Collection<PsiMethod> methods) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addFieldAssignments"));
        }
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addFieldAssignments"));
        }
        ArrayList<PsiExpressionStatement> assignments = new ArrayList<PsiExpressionStatement>();
        for (PsiMethod method : methods) {
            assignments.add(BaseMoveInitializerToMethodAction.addAssignment(BaseMoveInitializerToMethodAction.getOrCreateMethodBody(method), field));
        }
        ArrayList<PsiExpressionStatement> arrayList = assignments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addFieldAssignments"));
        }
        return arrayList;
    }

    @NotNull
    private static PsiCodeBlock getOrCreateMethodBody(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "getOrCreateMethodBody"));
        }
        PsiCodeBlock codeBlock = method.getBody();
        if (codeBlock == null) {
            CreateFromUsageUtils.setupMethodBody(method);
            codeBlock = method.getBody();
        }
        PsiCodeBlock psiCodeBlock = codeBlock;
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "getOrCreateMethodBody"));
        }
        return psiCodeBlock;
    }

    @NotNull
    protected abstract Collection<PsiMethod> getOrCreateMethods(@NotNull Project var1, @NotNull Editor var2, PsiFile var3, @NotNull PsiClass var4);

    @NotNull
    private static PsiExpressionStatement addAssignment(@NotNull PsiCodeBlock codeBlock, @NotNull PsiField field) throws IncorrectOperationException {
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addAssignment"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addAssignment"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)codeBlock.getProject()).getElementFactory();
        PsiExpressionStatement statement2 = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + " = y;", (PsiElement)codeBlock);
        PsiExpression initializer = field.getInitializer();
        initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, field.getType());
        PsiAssignmentExpression expression2 = (PsiAssignmentExpression)statement2.getExpression();
        expression2.getRExpression().replace((PsiElement)initializer);
        PsiElement newStatement = codeBlock.addBefore((PsiElement)statement2, BaseMoveInitializerToMethodAction.findFirstFieldUsage(codeBlock.getStatements(), field));
        BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(newStatement, newStatement, factory);
        PsiExpressionStatement psiExpressionStatement = (PsiExpressionStatement)newStatement;
        if (psiExpressionStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "addAssignment"));
        }
        return psiExpressionStatement;
    }

    @Nullable
    private static PsiElement findFirstFieldUsage(@NotNull PsiStatement[] statements, @NotNull PsiField field) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "findFirstFieldUsage"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "findFirstFieldUsage"));
        }
        for (PsiStatement blockStatement : statements) {
            if (BaseMoveInitializerToMethodAction.isSuperOrThisMethodCall(blockStatement) || !BaseMoveInitializerToMethodAction.containsReference((PsiElement)blockStatement, field)) continue;
            return blockStatement;
        }
        return null;
    }

    private static boolean isSuperOrThisMethodCall(@NotNull PsiStatement statement2) {
        PsiExpression expression2;
        if (statement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "isSuperOrThisMethodCall"));
        }
        return statement2 instanceof PsiExpressionStatement && RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)(expression2 = ((PsiExpressionStatement)statement2).getExpression()));
    }

    private static boolean containsReference(@NotNull PsiElement element, final @NotNull PsiField field) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "containsReference"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "containsReference"));
        }
        final Ref result2 = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == field) {
                    result2.set((Object)Boolean.TRUE);
                }
                super.visitReferenceExpression(expression2);
            }
        });
        return (Boolean)result2.get();
    }

    private static void replaceWithQualifiedReferences(@NotNull PsiElement expression2, @NotNull PsiElement root, @NotNull PsiElementFactory factory) throws IncorrectOperationException {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "replaceWithQualifiedReferences"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "replaceWithQualifiedReferences"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/BaseMoveInitializerToMethodAction", "replaceWithQualifiedReferences"));
        }
        PsiReference reference = expression2.getReference();
        if (reference == null) {
            for (PsiElement child : expression2.getChildren()) {
                BaseMoveInitializerToMethodAction.replaceWithQualifiedReferences(child, root, factory);
            }
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof PsiVariable && !(resolved instanceof PsiField) && !PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)resolved, (boolean)false)) {
            PsiVariable variable = (PsiVariable)resolved;
            PsiExpression qualifiedExpr = factory.createExpressionFromText("this." + variable.getName(), expression2);
            expression2.replace((PsiElement)qualifiedExpr);
        }
    }
}

