/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterDialog;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class CreateFieldFromParameterActionBase
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterActionBase.class);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "isAvailable"));
        }
        PsiParameter parameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (parameter == null || !this.isAvailable(parameter)) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.create.field.from.parameter.text", (Object[])new Object[]{parameter.getName()}));
        return true;
    }

    protected abstract boolean isAvailable(PsiParameter var1);

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.create.field.from.parameter.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "invoke"));
        }
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (myParameter == null || !FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        try {
            this.processParameter(project2, myParameter, !ApplicationManager.getApplication().isHeadlessEnvironment());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void processParameter(@NotNull Project project2, @NotNull PsiParameter myParameter, boolean isInteractive) {
        boolean isFinalToCalc;
        Object fieldNameToCalc;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "processParameter"));
        }
        if (myParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myParameter", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "processParameter"));
        }
        PsiType type2 = this.getSubstitutedType(myParameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, type2);
        Object[] names = suggestedNameInfo.names;
        if (isInteractive) {
            ArrayList<String> namesList = new ArrayList<String>();
            ContainerUtil.addAll(namesList, (Object[])names);
            String defaultName = styleManager.propertyNameToVariableName(propertyName, kind2);
            if (namesList.contains(defaultName)) {
                Collections.swap(namesList, 0, namesList.indexOf(defaultName));
            } else {
                namesList.add(0, defaultName);
            }
            names = ArrayUtil.toStringArray(namesList);
            CreateFieldFromParameterDialog dialog2 = new CreateFieldFromParameterDialog(project2, (String[])names, targetClass, method.isConstructor(), type2);
            if (!dialog2.showAndGet()) {
                return;
            }
            fieldNameToCalc = dialog2.getEnteredName();
            isFinalToCalc = dialog2.isDeclareFinal();
            suggestedNameInfo.nameChosen((String)fieldNameToCalc);
        } else {
            isFinalToCalc = !isMethodStatic && method.isConstructor();
            fieldNameToCalc = names[0];
        }
        boolean isFinal = isFinalToCalc;
        Object fieldName = fieldNameToCalc;
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$processParameter$0(project2, targetClass, method, myParameter, type2, (String)fieldName, isMethodStatic, isFinal));
    }

    protected abstract PsiType getSubstitutedType(PsiParameter var1);

    protected abstract void performRefactoring(Project var1, PsiClass var2, PsiMethod var3, PsiParameter var4, PsiType var5, String var6, boolean var7, boolean var8);

    public boolean startInWriteAction() {
        return false;
    }

    private /* synthetic */ void lambda$processParameter$0(@NotNull Project project2, PsiClass targetClass, PsiMethod method, @NotNull PsiParameter myParameter, PsiType type2, String fieldName, boolean isMethodStatic, boolean isFinal) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "lambda$processParameter$0"));
        }
        if (myParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myParameter", "com/intellij/codeInsight/intention/impl/CreateFieldFromParameterActionBase", "lambda$processParameter$0"));
        }
        try {
            this.performRefactoring(project2, targetClass, method, myParameter, type2, fieldName, isMethodStatic, isFinal);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

