/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExtractChainedMapAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractChainedMapAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractChainedMapAction", "isAvailable"));
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        if (variable == null || variable.getName() == null) {
            return false;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return false;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
        if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
            return false;
        }
        PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)declaration2.getParent(), PsiCodeBlock.class);
        if (block == null) {
            return false;
        }
        PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)block.getParent(), PsiLambdaExpression.class);
        ChainCallExtractor extractor = ChainCallExtractor.findExtractor(lambda2, initializer, variable.getType());
        if (extractor == null) {
            return false;
        }
        PsiParameter parameter = lambda2.getParameterList().getParameters()[0];
        if (!ReferencesSearch.search((PsiElement)parameter).forEach(ref -> PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)ref.getElement(), (boolean)false))) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.extract.map.step.text", (Object[])new Object[]{variable.getName(), extractor.getMethodName((PsiVariable)parameter, initializer, variable.getType())}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractChainedMapAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractChainedMapAction", "invoke"));
        }
        PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLocalVariable.class, (boolean)false, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        ChainCallExtractor.extractMappingStep(project2, variable);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.extract.map.step.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractChainedMapAction", "getFamilyName"));
        }
        return string;
    }
}

