/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collector;
import one.util.streamex.IntStreamEx;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractSetFromComparisonChainAction
extends PsiElementBaseIntentionAction {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));
    private static final String GUAVA_IMMUTABLE_SET = "com.google.common.collect.ImmutableSet";
    private static final String INITIALIZER_FORMAT_GUAVA = "com.google.common.collect.ImmutableSet.of({0})";
    private static final String INITIALIZER_FORMAT_JAVA2 = "java.util.Collections.unmodifiableSet(new java.util.HashSet(java.util.Arrays.asList(new String[] '{'{0}'}')))";
    private static final String INITIALIZER_FORMAT_JAVA5 = "java.util.Collections.unmodifiableSet(new java.util.HashSet<java.lang.String>(java.util.Arrays.asList({0})))";
    private static final String INITIALIZER_FORMAT_JAVA9 = "java.util.Set.of({0})";

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement result2;
        PsiReferenceExpression fieldRef;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "invoke"));
        }
        List comparisons = ExtractSetFromComparisonChainAction.comparisons(element).toList();
        if (comparisons.size() < 2) {
            return;
        }
        PsiExpression firstComparison = ((StringToConstantComparison)comparisons.get((int)0)).myComparison;
        PsiExpression lastComparison = ((StringToConstantComparison)comparisons.get((int)(comparisons.size() - 1))).myComparison;
        PsiExpression disjunction = (PsiExpression)ObjectUtils.tryCast((Object)firstComparison.getParent(), PsiPolyadicExpression.class);
        if (disjunction == null) {
            return;
        }
        PsiExpression stringExpression = ((StringToConstantComparison)comparisons.get((int)0)).myStringExpression;
        PsiClass containingClass = ClassUtils.getContainingStaticClass((PsiElement)disjunction);
        if (containingClass == null) {
            return;
        }
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        LinkedHashSet<String> suggestions = ExtractSetFromComparisonChainAction.getSuggestions(comparisons);
        String name2 = manager.suggestUniqueVariableName((String)suggestions.iterator().next(), (PsiElement)containingClass, false);
        String fieldInitializer = StreamEx.of((Collection)comparisons).map(cmp -> cmp.myConstant.getText()).joining((CharSequence)",");
        String pattern = this.getInitializer(containingClass);
        String initializer = MessageFormat.format(pattern, fieldInitializer);
        String modifiers = containingClass.isInterface() ? "" : "private static final ";
        String type2 = "java.util.Set" + (PsiUtil.isLanguageLevel5OrHigher((PsiElement)containingClass) ? "<java.lang.String>" : "");
        PsiField field = factory.createFieldFromText(modifiers + type2 + " " + name2 + "=" + initializer + ";", (PsiElement)containingClass);
        field = (PsiField)containingClass.add((PsiElement)field);
        PsiDiamondTypeUtil.removeRedundantTypeArguments((PsiElement)field);
        CodeStyleManager.getInstance((Project)project2).reformat(manager.shortenClassReferences((PsiElement)field));
        int startOffset = firstComparison.getStartOffsetInParent();
        int endOffset = lastComparison.getStartOffsetInParent() + lastComparison.getTextLength();
        String origText = disjunction.getText();
        String fieldReference = PsiResolveHelper.SERVICE.getInstance((Project)project2).resolveReferencedVariable(name2, (PsiElement)disjunction) == field ? name2 : containingClass.getQualifiedName() + "." + name2;
        String replacementText = origText.substring(0, startOffset) + fieldReference + ".contains(" + stringExpression.getText() + ")" + origText.substring(endOffset);
        PsiExpression replacement = factory.createExpressionFromText(replacementText, (PsiElement)disjunction);
        if (replacement instanceof PsiMethodCallExpression && disjunction.getParent() instanceof PsiParenthesizedExpression) {
            disjunction = (PsiExpression)disjunction.getParent();
        }
        if ((fieldRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope(result2 = disjunction.replace((PsiElement)replacement))).findFirst(), PsiReferenceExpression.class)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        editor.getCaretModel().moveToOffset(fieldRef.getTextOffset());
        editor.getSelectionModel().removeSelection();
        new MemberInplaceRenamer((PsiNamedElement)field, (PsiElement)field, editor).performInplaceRefactoring(suggestions);
    }

    @NotNull
    String getInitializer(PsiClass containingClass) {
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)containingClass)) {
            if (INITIALIZER_FORMAT_JAVA9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getInitializer"));
            }
            return INITIALIZER_FORMAT_JAVA9;
        }
        if (JavaPsiFacade.getInstance((Project)containingClass.getProject()).findClass(GUAVA_IMMUTABLE_SET, containingClass.getResolveScope()) != null) {
            if (INITIALIZER_FORMAT_GUAVA == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getInitializer"));
            }
            return INITIALIZER_FORMAT_GUAVA;
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)containingClass)) {
            if (INITIALIZER_FORMAT_JAVA5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getInitializer"));
            }
            return INITIALIZER_FORMAT_JAVA5;
        }
        if (INITIALIZER_FORMAT_JAVA2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getInitializer"));
        }
        return INITIALIZER_FORMAT_JAVA2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "isAvailable"));
        }
        return ExtractSetFromComparisonChainAction.comparisons(element).count() > 1L;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.extract.set.from.comparison.chain.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    private static LinkedHashSet<String> getSuggestions(List<StringToConstantComparison> comparisons) {
        PsiExpression stringExpression = comparisons.get((int)0).myStringExpression;
        Project project2 = stringExpression.getProject();
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        SuggestedNameInfo info = manager.suggestVariableName(VariableKind.STATIC_FINAL_FIELD, null, stringExpression, factory.createTypeFromText("java.lang.String", (PsiElement)stringExpression), false);
        LinkedHashSet suggestions = (LinkedHashSet)((StreamEx)StreamEx.of((Object[])info.names).without((Object[])new String[]{"OBJECT", "AN_OBJECT"}).map(StringUtil::pluralize).nonNull()).toCollection(LinkedHashSet::new);
        Pair prefixSuffix = (Pair)comparisons.stream().map(cmp -> cmp.myComputedConstant).collect(MoreCollectors.pairing((Collector)MoreCollectors.commonPrefix(), (Collector)MoreCollectors.commonSuffix(), Pair::create));
        ((StreamEx)((StreamEx)StreamEx.of((Object[])new String[]{(String)prefixSuffix.first, (String)prefixSuffix.second}).flatMap(str -> (StreamEx)StreamEx.split((CharSequence)str, (String)"\\W+").limit(3L)).filter(str -> str.length() >= 3 && StringUtil.isJavaIdentifier((String)str))).flatMap(str -> StreamEx.of((Object[])manager.suggestVariableName((VariableKind)VariableKind.STATIC_FINAL_FIELD, (String)str, null, null).names)).limit(5L)).map(StringUtil::pluralize).forEach(suggestions::add);
        suggestions.add("STRINGS");
        LinkedHashSet linkedHashSet = suggestions;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction", "getSuggestions"));
        }
        return linkedHashSet;
    }

    private static StreamEx<StringToConstantComparison> comparisons(PsiElement element) {
        int offset;
        int index;
        PsiPolyadicExpression disjunction = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class);
        if (disjunction == null || disjunction.getOperationTokenType() != JavaTokenType.OROR) {
            return StreamEx.empty();
        }
        Object[] operands2 = disjunction.getOperands();
        StringToConstantComparison anchorComparison = StringToConstantComparison.create((PsiExpression)operands2[index = IntStreamEx.ofIndices((Object[])operands2, arg_0 -> ExtractSetFromComparisonChainAction.lambda$comparisons$5(offset = element.getTextOffset() - disjunction.getTextOffset(), arg_0)).findFirst().orElse(operands2.length - 1)]);
        if (anchorComparison == null) {
            return StreamEx.empty();
        }
        List prefix = ((StreamEx)IntStreamEx.rangeClosed((int)(index - 1), (int)0, (int)-1).elements(operands2).map(StringToConstantComparison::create).takeWhile(anchorComparison::sameStringExpression)).toList();
        List suffix = ((StreamEx)StreamEx.of((Object[])operands2, (int)(index + 1), (int)operands2.length).map(StringToConstantComparison::create).takeWhile(anchorComparison::sameStringExpression)).toList();
        return StreamEx.ofReversed((List)prefix).append((Object)anchorComparison).append((Collection)suffix);
    }

    private static /* synthetic */ boolean lambda$comparisons$5(int offset, PsiExpression op) {
        return op.getStartOffsetInParent() + op.getTextLength() > offset;
    }

    static final class StringToConstantComparison {
        @NotNull
        PsiExpression myComparison;
        @NotNull
        PsiExpression myStringExpression;
        @NotNull
        PsiExpression myConstant;
        @NotNull
        String myComputedConstant;

        StringToConstantComparison(@NotNull PsiExpression comparison, @NotNull PsiExpression stringExpression, @NotNull PsiExpression constant, @NotNull String computedConstant) {
            if (comparison == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparison", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction$StringToConstantComparison", "<init>"));
            }
            if (stringExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringExpression", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction$StringToConstantComparison", "<init>"));
            }
            if (constant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constant", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction$StringToConstantComparison", "<init>"));
            }
            if (computedConstant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computedConstant", "com/intellij/codeInsight/intention/impl/ExtractSetFromComparisonChainAction$StringToConstantComparison", "<init>"));
            }
            this.myComparison = comparison;
            this.myStringExpression = stringExpression;
            this.myConstant = constant;
            this.myComputedConstant = computedConstant;
        }

        boolean sameStringExpression(@Nullable StringToConstantComparison other) {
            return other != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.myStringExpression, (PsiElement)other.myStringExpression);
        }

        static StringToConstantComparison create(PsiExpression candidate) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate), PsiMethodCallExpression.class);
            if (call == null) {
                return null;
            }
            if (MethodCallUtils.isEqualsCall(call)) {
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                PsiExpression argument = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                return StringToConstantComparison.fromComparison(candidate, qualifier, argument);
            }
            if (OBJECT_EQUALS.test(call)) {
                PsiExpression[] arguments = call.getArgumentList().getExpressions();
                return StringToConstantComparison.fromComparison(candidate, arguments[0], arguments[1]);
            }
            return null;
        }

        @Nullable
        private static StringToConstantComparison fromComparison(PsiExpression candidate, PsiExpression left, PsiExpression right) {
            if (left == null || right == null) {
                return null;
            }
            String leftConstant = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(left), String.class);
            if (leftConstant != null) {
                return new StringToConstantComparison(candidate, right, left, leftConstant);
            }
            String rightConstant = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(right), String.class);
            if (rightConstant != null) {
                return new StringToConstantComparison(candidate, left, right, rightConstant);
            }
            return null;
        }
    }
}

