/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickEditHandler
implements Disposable,
DocumentListener {
    private final Project myProject;
    private final QuickEditAction myAction;
    private final Editor myEditor;
    private final Document myOrigDocument;
    private final Document myNewDocument;
    private final PsiFile myNewFile;
    private final LightVirtualFile myNewVirtualFile;
    private final long myOrigCreationStamp;
    private EditorWindow mySplittedWindow;
    private boolean myCommittingToOriginal;
    private final PsiFile myInjectedFile;
    private final List<Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer>> myMarkers;
    @Nullable
    private final RangeMarker myAltFullRange;
    private static final Key<String> REPLACEMENT_KEY = Key.create((String)"REPLACEMENT_KEY");

    QuickEditHandler(Project project2, @NotNull PsiFile injectedFile, PsiFile origFile, Editor editor, QuickEditAction action) {
        if (injectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFile", "com/intellij/codeInsight/intention/impl/QuickEditHandler", "<init>"));
        }
        this.myMarkers = ContainerUtil.newLinkedList();
        this.myProject = project2;
        this.myEditor = editor;
        this.myAction = action;
        this.myOrigDocument = editor.getDocument();
        Place shreds = InjectedLanguageUtil.getShreds(injectedFile);
        FileType fileType = injectedFile.getFileType();
        Language language = injectedFile.getLanguage();
        PsiLanguageInjectionHost.Shred firstShred = (PsiLanguageInjectionHost.Shred)ContainerUtil.getFirstItem((List)((Object)shreds));
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        String text2 = InjectedLanguageManager.getInstance((Project)project2).getUnescapedText((PsiElement)injectedFile);
        String newFileName = StringUtil.notNullize((String)language.getDisplayName(), (String)"Injected") + " Fragment (" + origFile.getName() + ":" + firstShred.getHost().getTextRange().getStartOffset() + ")." + fileType.getDefaultExtension();
        this.myNewFile = factory.createFileFromText(newFileName, language, (CharSequence)text2, true, false);
        this.myNewVirtualFile = (LightVirtualFile)ObjectUtils.assertNotNull((Object)((LightVirtualFile)this.myNewFile.getVirtualFile()));
        this.myNewVirtualFile.setOriginalFile(origFile.getVirtualFile());
        assert (this.myNewFile != null) : "PSI file is null";
        assert (this.myNewFile.getTextLength() == this.myNewVirtualFile.getContent().length()) : "PSI / Virtual file text mismatch";
        this.myNewVirtualFile.setOriginalFile(origFile.getVirtualFile());
        this.myNewFile.putUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION, injectedFile.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION));
        this.myNewFile.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, shreds.getHostPointer());
        this.myNewDocument = PsiDocumentManager.getInstance((Project)project2).getDocument(this.myNewFile);
        assert (this.myNewDocument != null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myNewDocument, (ReadonlyFragmentModificationHandler)new MyQuietHandler());
        this.myOrigCreationStamp = this.myOrigDocument.getModificationStamp();
        this.myOrigDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        this.myNewDocument.addDocumentListener((DocumentListener)this, (Disposable)this);
        EditorFactory editorFactory = (EditorFactory)ObjectUtils.assertNotNull((Object)EditorFactory.getInstance());
        editorFactory.addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){
            int useCount;

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/intention/impl/QuickEditHandler$1", "editorCreated"));
                }
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                ++this.useCount;
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/intention/impl/QuickEditHandler$1", "editorReleased"));
                }
                if (event.getEditor().getDocument() != QuickEditHandler.this.myNewDocument) {
                    return;
                }
                if (--this.useCount > 0) {
                    return;
                }
                if (Boolean.TRUE.equals(QuickEditHandler.this.myNewVirtualFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                Disposer.dispose((Disposable)QuickEditHandler.this);
            }
        }, (Disposable)this);
        if ("JAVA".equals(firstShred.getHost().getLanguage().getID())) {
            PsiLanguageInjectionHost.Shred lastShred = (PsiLanguageInjectionHost.Shred)ContainerUtil.getLastItem((List)((Object)shreds));
            this.myAltFullRange = this.myOrigDocument.createRangeMarker(firstShred.getHostRangeMarker().getStartOffset(), lastShred.getHostRangeMarker().getEndOffset());
            this.myAltFullRange.setGreedyToLeft(true);
            this.myAltFullRange.setGreedyToRight(true);
            this.initGuardedBlocks(shreds);
            this.myInjectedFile = null;
        } else {
            this.initMarkers(shreds);
            this.myAltFullRange = null;
            this.myInjectedFile = injectedFile;
        }
    }

    public boolean isValid() {
        boolean valid;
        boolean bl = valid = this.myNewVirtualFile.isValid() && (this.myAltFullRange == null && this.myInjectedFile.isValid() || this.myAltFullRange != null && this.myAltFullRange.isValid());
        if (valid) {
            for (Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer> t : this.myMarkers) {
                if (((RangeMarker)t.first).isValid() && ((RangeMarker)t.second).isValid() && ((SmartPsiElementPointer)t.third).getElement() != null) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public void navigate(int injectedOffset) {
        if (this.myAction.isShowInBalloon()) {
            JComponent component = this.myAction.createBalloonComponent(this.myNewFile);
            if (component != null) {
                QuickEditHandler.showBalloon(this.myEditor, this.myNewFile, component);
            }
        } else {
            Editor editor;
            FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
            FileEditor[] editors = fileEditorManager.getEditors((VirtualFile)this.myNewVirtualFile);
            if (editors.length == 0) {
                EditorWindow curWindow = fileEditorManager.getCurrentWindow();
                this.mySplittedWindow = curWindow.split(0, false, (VirtualFile)this.myNewVirtualFile, true);
            }
            if ((editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(this.myProject, (VirtualFile)this.myNewVirtualFile, injectedOffset), true)) != null) {
                editor.putUserData(QuickEditAction.QUICK_EDIT_HANDLER, (Object)this);
                FoldingModel foldingModel = editor.getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    for (RangeMarker o : ContainerUtil.reverse(((DocumentEx)this.myNewDocument).getGuardedBlocks())) {
                        FoldRegion region;
                        String replacement = (String)o.getUserData(REPLACEMENT_KEY);
                        if (StringUtil.isEmpty((String)replacement) || (region = foldingModel.addFoldRegion(o.getStartOffset(), o.getEndOffset(), replacement)) == null) continue;
                        region.setExpanded(false);
                    }
                });
            }
            SwingUtilities.invokeLater(() -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE));
        }
    }

    public static void showBalloon(Editor editor, PsiFile newFile, JComponent component) {
        final Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder(component).setShadow(true).setAnimationCycle(0).setHideOnClickOutside(true).setHideOnKeyOutside(true).setHideOnAction(false).setFillColor(UIUtil.getControlColor()).createBalloon();
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                balloon.hide();
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, component);
        Disposer.register((Disposable)newFile.getProject(), (Disposable)balloon);
        Balloon.Position position = QuickEditAction.getBalloonPosition(editor);
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        if (position == Balloon.Position.above) {
            Point p = point.getPoint();
            point = new RelativePoint(point.getComponent(), new Point(p.x, p.y - editor.getLineHeight()));
        }
        balloon.show(point, position);
    }

    public void documentChanged(DocumentEvent e) {
        boolean undoOrRedo;
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        boolean bl = undoOrRedo = undoManager.isUndoInProgress() || undoManager.isRedoInProgress();
        if (undoOrRedo) {
            if (e.getDocument() == this.myOrigDocument) {
                SwingUtilities.invokeLater(() -> {
                    if (this.myOrigCreationStamp > this.myOrigDocument.getModificationStamp()) {
                        this.closeEditor();
                    }
                });
            }
        } else if (e.getDocument() == this.myNewDocument) {
            this.commitToOriginal(e);
            if (!this.isValid()) {
                ApplicationManager.getApplication().invokeLater(() -> this.closeEditor(), this.myProject.getDisposed());
            }
        } else if (e.getDocument() == this.myOrigDocument) {
            if (this.myCommittingToOriginal || this.myAltFullRange != null && this.myAltFullRange.isValid()) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.closeEditor(), this.myProject.getDisposed());
        }
    }

    private void closeEditor() {
        EditorWithProviderComposite[] editors;
        boolean unsplit = false;
        if (this.mySplittedWindow != null && !this.mySplittedWindow.isDisposed() && (editors = this.mySplittedWindow.getEditors()).length == 1 && Comparing.equal((Object)editors[0].getFile(), (Object)this.myNewVirtualFile)) {
            unsplit = true;
        }
        FileEditorManager.getInstance((Project)this.myProject).closeFile((VirtualFile)this.myNewVirtualFile);
        if (unsplit) {
            for (EditorWindow editorWindow : this.mySplittedWindow.findSiblings()) {
                editorWindow.unsplit(true);
            }
        }
    }

    public void initMarkers(Place shreds) {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        int curOffset = -1;
        Iterator iterator = shreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            RangeMarker rangeMarker = this.myNewDocument.createRangeMarker(shred.getRange().getStartOffset() + shred.getPrefix().length(), shred.getRange().getEndOffset() - shred.getSuffix().length());
            TextRange rangeInsideHost = shred.getRangeInsideHost();
            PsiLanguageInjectionHost host = shred.getHost();
            RangeMarker origMarker = this.myOrigDocument.createRangeMarker(rangeInsideHost.shiftRight(host.getTextRange().getStartOffset()));
            SmartPsiElementPointer elementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)host);
            Trinity markers = Trinity.create((Object)origMarker, (Object)rangeMarker, (Object)elementPointer);
            this.myMarkers.add((Trinity<RangeMarker, RangeMarker, SmartPsiElementPointer>)markers);
            origMarker.setGreedyToRight(true);
            rangeMarker.setGreedyToRight(true);
            if (origMarker.getStartOffset() > curOffset) {
                origMarker.setGreedyToLeft(true);
                rangeMarker.setGreedyToLeft(true);
            }
            curOffset = origMarker.getEndOffset();
        }
        this.initGuardedBlocks(shreds);
    }

    private void initGuardedBlocks(Place shreds) {
        int origOffset = -1;
        int curOffset = 0;
        Iterator iterator = shreds.iterator();
        while (iterator.hasNext()) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
            Segment hostRangeMarker = shred.getHostRangeMarker();
            int start = shred.getRange().getStartOffset() + shred.getPrefix().length();
            int end = shred.getRange().getEndOffset() - shred.getSuffix().length();
            if (curOffset < start) {
                RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, start);
                if (curOffset == 0 && shred == shreds.get(0)) {
                    guard.setGreedyToLeft(true);
                }
                String padding = origOffset < 0 ? "" : this.myOrigDocument.getText().substring(origOffset, hostRangeMarker.getStartOffset());
                guard.putUserData(REPLACEMENT_KEY, (Object)QuickEditHandler.fixQuotes(padding));
            }
            curOffset = end;
            origOffset = hostRangeMarker.getEndOffset();
        }
        if (curOffset < this.myNewDocument.getTextLength()) {
            RangeMarker guard = this.myNewDocument.createGuardedBlock(curOffset, this.myNewDocument.getTextLength());
            guard.setGreedyToRight(true);
            guard.putUserData(REPLACEMENT_KEY, (Object)"");
        }
    }

    private void commitToOriginal(DocumentEvent e) {
        this.myCommittingToOriginal = true;
        try {
            PostprocessReformattingAspect.getInstance(this.myProject).disablePostprocessFormattingInside(() -> {
                if (this.myAltFullRange != null) {
                    this.altCommitToOriginal(e);
                    return;
                }
                this.commitToOriginalInner();
            });
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myOrigDocument);
        }
        finally {
            this.myCommittingToOriginal = false;
        }
    }

    private void commitToOriginalInner() {
        String text2 = this.myNewDocument.getText();
        Map map2 = ContainerUtil.classify(this.myMarkers.iterator(), o -> {
            PsiElement element = ((SmartPsiElementPointer)o.third).getElement();
            return (PsiLanguageInjectionHost)element;
        });
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        documentManager.commitDocument(this.myOrigDocument);
        int localInsideFileCursor = 0;
        for (PsiLanguageInjectionHost host : map2.keySet()) {
            if (host == null) continue;
            String hostText = host.getText();
            ProperTextRange insideHost = null;
            StringBuilder sb = new StringBuilder();
            for (Trinity entry : (Set)map2.get(host)) {
                RangeMarker origMarker = (RangeMarker)entry.first;
                int hostOffset = host.getTextRange().getStartOffset();
                ProperTextRange localInsideHost = new ProperTextRange(origMarker.getStartOffset() - hostOffset, origMarker.getEndOffset() - hostOffset);
                RangeMarker rangeMarker = (RangeMarker)entry.second;
                ProperTextRange localInsideFile = new ProperTextRange(Math.max(localInsideFileCursor, rangeMarker.getStartOffset()), rangeMarker.getEndOffset());
                if (insideHost != null) {
                    sb.append(hostText.substring(insideHost.getEndOffset(), localInsideHost.getStartOffset()));
                }
                sb.append(localInsideFile.getEndOffset() <= text2.length() && !localInsideFile.isEmpty() ? localInsideFile.substring(text2) : "");
                localInsideFileCursor = localInsideFile.getEndOffset();
                insideHost = insideHost == null ? localInsideHost : insideHost.union((TextRange)localInsideHost);
            }
            assert (insideHost != null);
            ElementManipulators.getManipulator((PsiElement)host).handleContentChange((PsiElement)host, insideHost, sb.toString());
            documentManager.commitDocument(this.myOrigDocument);
        }
    }

    private void altCommitToOriginal(@NotNull DocumentEvent e) {
        DocumentWindow documentWindow;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/QuickEditHandler", "altCommitToOriginal"));
        }
        PsiFile origPsiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myOrigDocument);
        String newText = this.myNewDocument.getText();
        LinkedHashMap replacementMap = new LinkedHashMap();
        int count = 0;
        for (Object o : ContainerUtil.reverse(((DocumentEx)this.myNewDocument).getGuardedBlocks())) {
            String replacement = (String)o.getUserData(REPLACEMENT_KEY);
            String tempText = "REPLACE" + count++ + Long.toHexString(StringHash.calc((String)replacement));
            newText = newText.substring(0, o.getStartOffset()) + tempText + newText.substring(o.getEndOffset());
            replacementMap.put((Object)tempText, (Object)replacement);
        }
        int hostStartOffset = this.myAltFullRange.getStartOffset();
        this.myEditor.getCaretModel().moveToOffset(hostStartOffset);
        for (CopyPastePreProcessor preProcessor : (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME)) {
            newText = preProcessor.preprocessOnPaste(this.myProject, origPsiFile, this.myEditor, newText, null);
        }
        this.myOrigDocument.replaceString(hostStartOffset, this.myAltFullRange.getEndOffset(), (CharSequence)newText);
        for (String tempText : replacementMap.keySet()) {
            int idx = CharArrayUtil.indexOf((CharSequence)this.myOrigDocument.getCharsSequence(), (CharSequence)tempText, (int)hostStartOffset, (int)this.myAltFullRange.getEndOffset());
            this.myOrigDocument.replaceString(idx, idx + tempText.length(), (CharSequence)replacementMap.get((Object)tempText));
        }
        QuickEditHandler.fixDocumentQuotes(this.myOrigDocument, hostStartOffset - 1);
        QuickEditHandler.fixDocumentQuotes(this.myOrigDocument, this.myAltFullRange.getEndOffset());
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myOrigDocument);
        try {
            CodeStyleManager.getInstance((Project)this.myProject).reformatRange((PsiElement)origPsiFile, hostStartOffset, this.myAltFullRange.getEndOffset(), true);
        }
        catch (IncorrectOperationException o) {
            // empty catch block
        }
        PsiElement newInjected = InjectedLanguageManager.getInstance((Project)this.myProject).findInjectedElementAt(origPsiFile, hostStartOffset);
        DocumentWindow documentWindow2 = documentWindow = newInjected == null ? null : InjectedLanguageUtil.getDocumentWindow(newInjected);
        if (documentWindow != null) {
            this.myEditor.getCaretModel().moveToOffset(documentWindow.injectedToHost(e.getOffset()));
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    private static String fixQuotes(String padding) {
        if (padding.isEmpty()) {
            return padding;
        }
        if (padding.startsWith("'")) {
            padding = '\"' + padding.substring(1);
        }
        if (padding.endsWith("'")) {
            padding = padding.substring(0, padding.length() - 1) + "\"";
        }
        return padding;
    }

    private static void fixDocumentQuotes(Document doc, int offset) {
        if (doc.getCharsSequence().charAt(offset) == '\'') {
            doc.replaceString(offset, offset + 1, (CharSequence)"\"");
        }
    }

    public void dispose() {
    }

    public PsiFile getNewFile() {
        return this.myNewFile;
    }

    public boolean changesRange(TextRange range) {
        if (this.myAltFullRange != null) {
            return range.intersects(this.myAltFullRange.getStartOffset(), this.myAltFullRange.getEndOffset());
        }
        if (!this.myMarkers.isEmpty()) {
            TextRange hostRange = TextRange.create((int)((RangeMarker)this.myMarkers.get((int)0).first).getStartOffset(), (int)((RangeMarker)this.myMarkers.get((int)(this.myMarkers.size() - 1)).first).getEndOffset());
            return range.intersects(hostRange);
        }
        return false;
    }

    private static class MyQuietHandler
    implements ReadonlyFragmentModificationHandler {
        private MyQuietHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }
}

