/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentWithComparisonFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public ReplaceAssignmentWithComparisonFix(PsiAssignmentExpression expr) {
        super((PsiElement)expr);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "invoke"));
        }
        PsiBinaryExpression comparisonExpr = (PsiBinaryExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("a==b", startElement);
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)startElement;
        comparisonExpr.getLOperand().replace((PsiElement)assignmentExpression.getLExpression());
        PsiExpression rOperand = comparisonExpr.getROperand();
        assert (rOperand != null);
        PsiExpression rExpression = assignmentExpression.getRExpression();
        assert (rExpression != null);
        rOperand.replace((PsiElement)rExpression);
        CodeStyleManager.getInstance((Project)project2).reformat(assignmentExpression.replace((PsiElement)comparisonExpr));
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.replace.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ReplaceAssignmentWithComparisonFix", "getFamilyName"));
        }
        return string;
    }
}

