/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.UrlClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionMetaData
extends BeforeAfterActionMetaData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData");
    @NotNull
    private final IntentionAction myAction;
    @NotNull
    public final String[] myCategory;
    private URL myDirURL;
    @NonNls
    private static final String INTENTION_DESCRIPTION_FOLDER = "intentionDescriptions";

    public IntentionActionMetaData(@NotNull IntentionAction action, @Nullable ClassLoader loader, @NotNull String[] category, @NotNull String descriptionDirectoryName) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (descriptionDirectoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionDirectoryName", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        super(loader, descriptionDirectoryName);
        this.myDirURL = null;
        this.myAction = action;
        this.myCategory = category;
    }

    public IntentionActionMetaData(@NotNull IntentionAction action, @NotNull String[] category, TextDescriptor description, TextDescriptor[] exampleUsagesBefore, TextDescriptor[] exampleUsagesAfter) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "<init>"));
        }
        super(description, exampleUsagesBefore, exampleUsagesAfter);
        this.myDirURL = null;
        this.myAction = action;
        this.myCategory = category;
    }

    public String toString() {
        return this.getFamily();
    }

    @Nullable
    private static URL getIntentionDescriptionDirURL(ClassLoader aClassLoader, String intentionFolderName) {
        URL pageURL = aClassLoader.getResource("intentionDescriptions/" + intentionFolderName + "/" + "description.html");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Path:intentionDescriptions/" + intentionFolderName);
            LOG.debug("URL:" + pageURL);
        }
        if (pageURL != null) {
            try {
                String url = pageURL.toExternalForm();
                return UrlClassLoader.internProtocol((URL)new URL(url.substring(0, url.lastIndexOf(47))));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public PluginId getPluginId() {
        if (this.myLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)((Object)this.myLoader)).getPluginId();
        }
        return null;
    }

    @NotNull
    public String getFamily() {
        String string = this.myAction.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getFamily"));
        }
        return string;
    }

    @NotNull
    public IntentionAction getAction() {
        IntentionAction intentionAction = this.myAction;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getAction"));
        }
        return intentionAction;
    }

    @Override
    @NotNull
    protected URL getDirURL() {
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myLoader, this.myDescriptionDirectoryName);
        }
        if (this.myDirURL == null) {
            this.myDirURL = IntentionActionMetaData.getIntentionDescriptionDirURL(this.myLoader, this.getFamily());
        }
        if (this.myDirURL == null) {
            PluginId pluginId = this.getPluginId();
            String errorMessage = "Intention Description Dir URL is null: " + this.getFamily() + "; " + this.myDescriptionDirectoryName;
            if (pluginId != null) {
                throw new PluginException(errorMessage, pluginId);
            }
            throw new RuntimeException(errorMessage);
        }
        URL uRL = this.myDirURL;
        if (uRL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionMetaData", "getDirURL"));
        }
        return uRL;
    }
}

