/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper");
    private IntentionAction myDelegate;
    private final String[] myCategories;
    private final IntentionActionBean myExtension;
    private String myFullFamilyName;

    IntentionActionWrapper(@NotNull IntentionActionBean extension, String[] categories) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "<init>"));
        }
        this.myExtension = extension;
        this.myCategories = categories;
    }

    @NotNull
    public String getText() {
        String string = this.getDelegate().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getDelegate().getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "isAvailable"));
        }
        return this.getDelegate().isAvailable(project2, editor, file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "invoke"));
        }
        this.getDelegate().invoke(project2, editor, file2);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getElementToMakeWritable"));
        }
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.myFullFamilyName;
        if (result2 == null) {
            result2 = this.myCategories != null ? StringUtil.join((String[])this.myCategories, (String)"/") + "/" + this.getFamilyName() : this.getFamilyName();
            this.myFullFamilyName = result2;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getFullFamilyName"));
        }
        return string;
    }

    @NotNull
    public synchronized IntentionAction getDelegate() {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = this.myExtension.instantiate();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        IntentionAction intentionAction = this.myDelegate;
        if (intentionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getDelegate"));
        }
        return intentionAction;
    }

    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    @NotNull
    ClassLoader getImplementationClassLoader() {
        ClassLoader classLoader = this.myExtension.getLoaderForClass();
        if (classLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper", "getImplementationClassLoader"));
        }
        return classLoader;
    }

    public String toString() {
        return "Intention: (" + this.getDelegate().getClass() + "): '" + this.getText() + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate = this.getDelegate();
        return delegate instanceof ShortcutProvider ? ((ShortcutProvider)delegate).getShortcut() : null;
    }
}

