/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IntentionDescriptionPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel");
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;
    private TitledSeparator myBeforeSeparator;
    private TitledSeparator myAfterSeparator;
    private JPanel myPoweredByPanel;
    private final List<IntentionUsagePanel> myBeforeUsagePanels;
    private final List<IntentionUsagePanel> myAfterUsagePanels;
    @NonNls
    private static final String BEFORE_TEMPLATE = "before.java.template";
    @NonNls
    private static final String AFTER_TEMPLATE = "after.java.template";

    public IntentionDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myBeforeUsagePanels = new ArrayList<IntentionUsagePanel>();
        this.myAfterUsagePanels = new ArrayList<IntentionUsagePanel>();
        this.myDescriptionBrowser.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        });
    }

    private boolean readHTML(String text2) {
        try {
            this.myDescriptionBrowser.read(new StringReader(text2), null);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private String toHTML(String text2) {
        HintHint hintHint = new HintHint(this.myDescriptionBrowser, new Point(0, 0));
        hintHint.setFont(UIUtil.getLabelFont());
        return HintUtil.prepareHintText(text2, hintHint);
    }

    public void reset(IntentionActionMetaData actionMetaData, String filter) {
        try {
            TextDescriptor url = actionMetaData.getDescription();
            String description = StringUtil.isEmpty((String)url.getText()) ? this.toHTML(CodeInsightBundle.message((String)"under.construction.string", (Object[])new Object[0])) : SearchUtil.markup(this.toHTML(url.getText()), filter);
            this.readHTML(description);
            this.setupPoweredByPanel(actionMetaData);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeSeparator, this.myBeforeUsagePanels, actionMetaData.getExampleUsagesBefore());
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterSeparator, this.myAfterUsagePanels, actionMetaData.getExampleUsagesAfter());
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void setupPoweredByPanel(IntentionActionMetaData actionMetaData) {
        JLabel owner2;
        PluginId pluginId;
        PluginId pluginId2 = pluginId = actionMetaData == null ? null : actionMetaData.getPluginId();
        if (pluginId == null) {
            String label = XmlStringUtil.wrapInHtml((CharSequence)("<b>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</b>"));
            owner2 = new JLabel(label);
        } else {
            final IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
            HyperlinkLabel label = new HyperlinkLabel(CodeInsightBundle.message((String)"powered.by.plugin", (Object[])new Object[]{pluginDescriptor.getName()}));
            label.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                    PluginManagerConfigurable pluginConfigurable = new PluginManagerConfigurable(PluginManagerUISettings.getInstance());
                    Project project2 = ProjectManager.getInstance().getDefaultProject();
                    util.editConfigurable(project2, (Configurable)pluginConfigurable, () -> pluginConfigurable.select(pluginDescriptor));
                }
            });
            owner2 = label;
        }
        this.myPoweredByPanel.removeAll();
        this.myPoweredByPanel.add((Component)owner2, "Center");
    }

    public void reset(String intentionCategory) {
        try {
            this.readHTML(this.toHTML(CodeInsightBundle.message((String)"intention.settings.category.text", (Object[])new Object[]{intentionCategory})));
            this.setupPoweredByPanel(null);
            URL beforeURL = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/" + BEFORE_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeSeparator, this.myBeforeUsagePanels, new ResourceTextDescriptor[]{new ResourceTextDescriptor(beforeURL)});
            URL afterURL = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/" + AFTER_TEMPLATE);
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterSeparator, this.myAfterUsagePanels, new ResourceTextDescriptor[]{new ResourceTextDescriptor(afterURL)});
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void showUsages(JPanel panel2, TitledSeparator separator, List<IntentionUsagePanel> usagePanels, @Nullable TextDescriptor[] exampleUsages) throws IOException {
        boolean reuse;
        GridBagConstraints gb = null;
        boolean bl = reuse = exampleUsages != null && panel2.getComponents().length == exampleUsages.length;
        if (!reuse) {
            IntentionDescriptionPanel.disposeUsagePanels(usagePanels);
            panel2.setLayout(new GridBagLayout());
            panel2.removeAll();
            gb = new GridBagConstraints();
            gb.anchor = 18;
            gb.fill = 1;
            gb.gridheight = 0;
            gb.gridwidth = 1;
            gb.gridx = 0;
            gb.gridy = 0;
            gb.insets = new Insets(0, 0, 0, 0);
            gb.ipadx = 5;
            gb.ipady = 5;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
        }
        if (exampleUsages != null) {
            for (int i2 = 0; i2 < exampleUsages.length; ++i2) {
                IntentionUsagePanel usagePanel;
                TextDescriptor exampleUsage = exampleUsages[i2];
                String name2 = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension = fileTypeManager.getExtension(name2);
                FileType fileType = fileTypeManager.getFileTypeByExtension(extension);
                if (reuse) {
                    usagePanel = (IntentionUsagePanel)panel2.getComponent(i2);
                } else {
                    usagePanel = new IntentionUsagePanel();
                    usagePanels.add(usagePanel);
                }
                usagePanel.reset(exampleUsage.getText(), fileType);
                if (reuse) continue;
                if (i2 == exampleUsages.length) {
                    gb.gridwidth = 0;
                }
                panel2.add((Component)usagePanel, gb);
                ++gb.gridx;
            }
        }
        panel2.revalidate();
        panel2.repaint();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        IntentionDescriptionPanel.disposeUsagePanels(this.myBeforeUsagePanels);
        IntentionDescriptionPanel.disposeUsagePanels(this.myAfterUsagePanels);
    }

    private static void disposeUsagePanels(List<IntentionUsagePanel> usagePanels) {
        for (IntentionUsagePanel usagePanel : usagePanels) {
            Disposer.dispose((Disposable)usagePanel);
        }
        usagePanels.clear();
    }

    public void init(int preferredWidth) {
        double height = (this.myDescriptionBrowser.getSize().getHeight() + this.myBeforePanel.getSize().getHeight() + this.myAfterPanel.getSize().getHeight()) / 3.0;
        Dimension newd = new Dimension(preferredWidth, (int)height);
        this.myDescriptionBrowser.setSize(newd);
        this.myDescriptionBrowser.setPreferredSize(newd);
        this.myDescriptionBrowser.setMaximumSize(newd);
        this.myDescriptionBrowser.setMinimumSize(newd);
        this.myBeforePanel.setSize(newd);
        this.myBeforePanel.setPreferredSize(newd);
        this.myBeforePanel.setMaximumSize(newd);
        this.myBeforePanel.setMinimumSize(newd);
        this.myAfterPanel.setSize(newd);
        this.myAfterPanel.setPreferredSize(newd);
        this.myAfterPanel.setMaximumSize(newd);
        this.myAfterPanel.setMinimumSize(newd);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TitledSeparator titledSeparator;
        TitledSeparator titledSeparator2;
        JPanel jPanel2;
        JPanel jPanel3;
        JEditorPane jEditorPane;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setAlignmentY(0.2f);
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, new Dimension(-1, 100), null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/CodeInsightBundle").getString("dialog.intention.settings.description.panel.title"), (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAfterPanel = jPanel3 = new JPanel();
        jPanel6.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforePanel = jPanel2 = new JPanel();
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforeSeparator = titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Before");
        jPanel6.add((Component)titledSeparator2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAfterSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setAlignmentY(0.2f);
        titledSeparator.setText("After");
        jPanel6.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myPoweredByPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/CodeInsightBundle").getString("powered.by"), (int)0, (int)0, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

