/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiFile;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LazyEditor
extends UserDataHolderBase
implements Editor {
    private final PsiFile myFile;
    private Editor myEditor;

    public LazyEditor(PsiFile file2) {
        this.myFile = file2;
    }

    private Editor getEditor() {
        if (this.myEditor == null) {
            Project project2 = this.myFile.getProject();
            this.myEditor = FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, this.myFile.getVirtualFile(), 0), false);
            assert (this.myEditor != null);
        }
        return this.myEditor;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.getEditor().getDocument();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getDocument"));
        }
        return document;
    }

    public boolean isViewer() {
        return this.getEditor().isViewer();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.getEditor().getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getComponent"));
        }
        return jComponent;
    }

    @NotNull
    public JComponent getContentComponent() {
        JComponent jComponent = this.getEditor().getContentComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getContentComponent"));
        }
        return jComponent;
    }

    public void setBorder(@Nullable Border border) {
        this.getEditor().setBorder(border);
    }

    public Insets getInsets() {
        return this.getEditor().getInsets();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.getEditor().getSelectionModel();
        if (selectionModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getSelectionModel"));
        }
        return selectionModel;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        MarkupModel markupModel = this.getEditor().getMarkupModel();
        if (markupModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getMarkupModel"));
        }
        return markupModel;
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        FoldingModel foldingModel = this.getEditor().getFoldingModel();
        if (foldingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getFoldingModel"));
        }
        return foldingModel;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        ScrollingModel scrollingModel = this.getEditor().getScrollingModel();
        if (scrollingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getScrollingModel"));
        }
        return scrollingModel;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.getEditor().getCaretModel();
        if (caretModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getCaretModel"));
        }
        return caretModel;
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        SoftWrapModel softWrapModel = this.getEditor().getSoftWrapModel();
        if (softWrapModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getSoftWrapModel"));
        }
        return softWrapModel;
    }

    @NotNull
    public InlayModel getInlayModel() {
        InlayModel inlayModel = this.getEditor().getInlayModel();
        if (inlayModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getInlayModel"));
        }
        return inlayModel;
    }

    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = this.getEditor().getEditorKind();
        if (editorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getEditorKind"));
        }
        return editorKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        EditorSettings editorSettings = this.getEditor().getSettings();
        if (editorSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getSettings"));
        }
        return editorSettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.getEditor().getColorsScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    public int getLineHeight() {
        return this.getEditor().getLineHeight();
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "logicalPositionToXY"));
        }
        Point point = this.getEditor().logicalPositionToXY(pos);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "logicalPositionToXY"));
        }
        return point;
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "logicalPositionToOffset"));
        }
        return this.getEditor().logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logicalPos", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "logicalToVisualPosition"));
        }
        VisualPosition visualPosition = this.getEditor().logicalToVisualPosition(logicalPos);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "logicalToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visible", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualPositionToXY"));
        }
        Point point = this.getEditor().visualPositionToXY(visible);
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualPositionToXY"));
        }
        return point;
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualPositionToPoint2D"));
        }
        Point2D point2D = this.getEditor().visualPositionToPoint2D(pos);
        if (point2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualPositionToPoint2D"));
        }
        return point2D;
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePos", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualToLogicalPosition"));
        }
        LogicalPosition logicalPosition = this.getEditor().visualToLogicalPosition(visiblePos);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "visualToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.getEditor().offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(offset);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.getEditor().offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "offsetToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToLogicalPosition"));
        }
        LogicalPosition logicalPosition = this.getEditor().xyToLogicalPosition(p);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToVisualPosition"));
        }
        VisualPosition visualPosition = this.getEditor().xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToVisualPosition"));
        }
        VisualPosition visualPosition = this.getEditor().xyToVisualPosition(p);
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "xyToVisualPosition"));
        }
        return visualPosition;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "addEditorMouseListener"));
        }
        this.getEditor().addEditorMouseListener(listener2);
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "removeEditorMouseListener"));
        }
        this.getEditor().removeEditorMouseListener(listener2);
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "addEditorMouseMotionListener"));
        }
        this.getEditor().addEditorMouseMotionListener(listener2);
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "removeEditorMouseMotionListener"));
        }
        this.getEditor().removeEditorMouseMotionListener(listener2);
    }

    public boolean isDisposed() {
        return this.getEditor().isDisposed();
    }

    @Nullable
    public Project getProject() {
        return this.getEditor().getProject();
    }

    public boolean isInsertMode() {
        return this.getEditor().isInsertMode();
    }

    public boolean isColumnMode() {
        return this.getEditor().isColumnMode();
    }

    public boolean isOneLineMode() {
        return this.getEditor().isOneLineMode();
    }

    @NotNull
    public EditorGutter getGutter() {
        EditorGutter editorGutter = this.getEditor().getGutter();
        if (editorGutter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getGutter"));
        }
        return editorGutter;
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getMouseEventArea"));
        }
        return this.getEditor().getMouseEventArea(e);
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        this.getEditor().setHeaderComponent(header);
    }

    public boolean hasHeaderComponent() {
        return this.getEditor().hasHeaderComponent();
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return this.getEditor().getHeaderComponent();
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        IndentsModel indentsModel = this.getEditor().getIndentsModel();
        if (indentsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/config/LazyEditor", "getIndentsModel"));
        }
        return indentsModel;
    }
}

