/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FlatteningIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComparingClassifier<T>
extends Classifier<T> {
    private final boolean myNegated;

    protected ComparingClassifier(Classifier<T> next, String name2, boolean negated) {
        super(next, name2);
        this.myNegated = negated;
    }

    @Nullable
    public abstract Comparable getWeight(T var1, ProcessingContext var2);

    @Override
    @NotNull
    public Iterable<T> classify(@NotNull Iterable<T> source, final @NotNull ProcessingContext context) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/lookup/ComparingClassifier", "classify"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/ComparingClassifier", "classify"));
        }
        List nulls = null;
        TreeMap<Comparable, SmartList> map2 = new TreeMap<Comparable, SmartList>();
        for (T t : source) {
            Comparable weight = this.getWeight(t, context);
            if (weight == null) {
                if (nulls == null) {
                    nulls = new SmartList();
                }
                nulls.add(t);
                continue;
            }
            List list2 = (List)map2.get(weight);
            if (list2 == null) {
                list2 = new SmartList();
                map2.put(weight, (SmartList)list2);
            }
            list2.add(t);
        }
        final ArrayList values = new ArrayList();
        values.addAll(this.myNegated ? map2.descendingMap().values() : map2.values());
        ContainerUtil.addIfNotNull(values, (Object)nulls);
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FlatteningIterator<List<T>, T>(values.iterator()){

                    protected Iterator<T> createValueIterator(List<T> group) {
                        return ComparingClassifier.this.myNext.classify(group, context).iterator();
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/ComparingClassifier", "classify"));
        }
        return iterable;
    }

    @Override
    @NotNull
    public List<Pair<T, Object>> getSortingWeights(@NotNull Iterable<T> items, @NotNull ProcessingContext context) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/lookup/ComparingClassifier", "getSortingWeights"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/ComparingClassifier", "getSortingWeights"));
        }
        List list2 = ContainerUtil.map(items, t -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/lookup/ComparingClassifier", "lambda$getSortingWeights$0"));
            }
            return new Pair(t, (Object)this.getWeight(t, context));
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/ComparingClassifier", "getSortingWeights"));
        }
        return list2;
    }
}

