/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElementAction {
    private final Icon myIcon;
    private final String myText;

    protected LookupElementAction(@Nullable Icon icon, @NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/lookup/LookupElementAction", "<init>"));
        }
        this.myIcon = icon;
        this.myText = text2;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public String getText() {
        return this.myText;
    }

    public abstract Result performLookupAction();

    public static class Result {
        public static final Result HIDE_LOOKUP = new Result();
        public static final Result REFRESH_ITEM = new Result();

        public static class ChooseItem
        extends Result {
            public final LookupElement item;

            public ChooseItem(LookupElement item) {
                this.item = item;
            }
        }
    }
}

