/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.Nullable;

public class StartNewLineHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public StartNewLineHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    protected void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Runnable callOriginal = () -> {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        };
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup != null && lookup.getLookupStart() == lookup.getLookupOriginalStart()) {
            lookup.performGuardedChange(callOriginal);
            lookup.moveToCaretPosition();
        } else {
            callOriginal.run();
        }
    }
}

