/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewHint
extends LightweightHint
implements Disposable {
    private static final Key<EmmetPreviewHint> KEY = new Key("emmet.preview");
    @NotNull
    private final Editor myParentEditor;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Alarm myAlarm;
    private boolean isDisposed;

    private EmmetPreviewHint(@NotNull JBPanel panel2, @NotNull Editor editor, @NotNull Editor parentEditor) {
        if (panel2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "<init>"));
        }
        if (parentEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentEditor", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "<init>"));
        }
        super((JComponent)panel2);
        this.myAlarm = new Alarm((Disposable)this);
        this.isDisposed = false;
        this.myParentEditor = parentEditor;
        this.myEditor = editor;
        final Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(this.myParentEditor);
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$1", "editorReleased"));
                }
                if (event.getEditor() == EmmetPreviewHint.this.myParentEditor || event.getEditor() == EmmetPreviewHint.this.myEditor || event.getEditor() == topLevelEditor) {
                    EmmetPreviewHint.this.hide(true);
                }
            }
        }, (Disposable)this);
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (!EmmetPreviewHint.this.isDisposed && event.isWholeTextReplaced()) {
                    Pair position = EmmetPreviewHint.this.guessPosition();
                    HintManagerImpl.adjustEditorHintPosition(EmmetPreviewHint.this, EmmetPreviewHint.this.myParentEditor, (Point)position.first, (Short)position.second);
                    EmmetPreviewHint.this.myEditor.getScrollingModel().scrollVertically(0);
                }
            }
        }, (Disposable)this);
    }

    public void showHint() {
        this.myParentEditor.putUserData(KEY, (Object)this);
        Pair<Point, Short> position = this.guessPosition();
        JRootPane pane = this.myParentEditor.getComponent().getRootPane();
        JComponent layeredPane = pane != null ? pane.getLayeredPane() : this.myParentEditor.getComponent();
        HintHint hintHint = new HintHint(layeredPane, (Point)position.first).setAwtTooltip(true).setContentActive(true).setExplicitClose(true).setShowImmediately(true).setPreferredPosition((Short)position.second == 1 ? Balloon.Position.above : Balloon.Position.below).setTextBg(this.myParentEditor.getColorsScheme().getDefaultBackground()).setBorderInsets((Insets)JBUI.insets((int)1));
        int hintFlags = 145;
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)this, this.myParentEditor, (Point)position.first, hintFlags, 0, false, hintHint);
    }

    public void updateText(@NotNull Producer<String> contentProducer) {
        if (contentProducer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentProducer", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "updateText"));
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (contentProducer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentProducer", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "lambda$updateText$1"));
            }
            if (!this.isDisposed) {
                String newText = (String)contentProducer.produce();
                if (StringUtil.isEmpty((String)newText)) {
                    this.hide();
                } else if (!this.myEditor.getDocument().getText().equals(newText)) {
                    DocumentUtil.writeInRunUndoTransparentAction(() -> this.myEditor.getDocument().setText((CharSequence)newText));
                }
            }
        }, 100);
    }

    @NotNull
    public String getContent() {
        String string = this.myEditor.getDocument().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "getContent"));
        }
        return string;
    }

    @Nullable
    public static EmmetPreviewHint getExistingHint(@NotNull Editor parentEditor) {
        if (parentEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentEditor", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "getExistingHint"));
        }
        EmmetPreviewHint emmetPreviewHint = (EmmetPreviewHint)KEY.get((UserDataHolder)parentEditor);
        if (emmetPreviewHint != null) {
            if (!emmetPreviewHint.isDisposed) {
                return emmetPreviewHint;
            }
            emmetPreviewHint.hide();
        }
        return null;
    }

    @NotNull
    public static EmmetPreviewHint createHint(final @NotNull EditorEx parentEditor, @NotNull String templateText, @NotNull FileType fileType) {
        Document document;
        if (parentEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentEditor", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "createHint"));
        }
        if (templateText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateText", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "createHint"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "createHint"));
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorEx previewEditor = (EditorEx)editorFactory.createEditor(document = editorFactory.createDocument((CharSequence)templateText), parentEditor.getProject(), fileType, true);
        MarkupModelEx model = previewEditor.getMarkupModel();
        if (model instanceof EditorMarkupModel) {
            ((EditorMarkupModel)((Object)model)).setErrorStripeVisible(true);
        }
        final EditorSettings settings = previewEditor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setAdditionalLinesCount(1);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        settings.setCaretRowShown(false);
        previewEditor.setCaretEnabled(false);
        previewEditor.setBorder(IdeBorderFactory.createEmptyBorder());
        JBPanel panel2 = new JBPanel(new BorderLayout()){

            @NotNull
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension parentEditorSize = parentEditor.getScrollPane().getSize();
                int maxWidth = (int)parentEditorSize.getWidth() / 3;
                int maxHeight = (int)parentEditorSize.getHeight() / 2;
                int width = settings.isUseSoftWraps() ? maxWidth : Math.min((int)size.getWidth(), maxWidth);
                int height = Math.min((int)size.getHeight(), maxHeight);
                Dimension dimension = new Dimension(width, height);
                if (dimension == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$3", "getPreferredSize"));
                }
                return dimension;
            }

            @NotNull
            public Insets getInsets() {
                Insets insets = new Insets(1, 2, 0, 0);
                if (insets == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint$3", "getInsets"));
                }
                return insets;
            }
        };
        panel2.setBackground(previewEditor.getBackgroundColor());
        panel2.add((Component)previewEditor.getComponent(), (Object)"Center");
        EmmetPreviewHint emmetPreviewHint = new EmmetPreviewHint(panel2, previewEditor, parentEditor);
        if (emmetPreviewHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "createHint"));
        }
        return emmetPreviewHint;
    }

    @Override
    public boolean vetoesHiding() {
        return true;
    }

    @Override
    public void hide(boolean ok) {
        super.hide(ok);
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this));
    }

    public void dispose() {
        this.isDisposed = true;
        this.myAlarm.cancelAllRequests();
        EmmetPreviewHint existingBalloon = (EmmetPreviewHint)this.myParentEditor.getUserData(KEY);
        if (existingBalloon == this) {
            this.myParentEditor.putUserData(KEY, null);
        }
        if (!this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }
    }

    @NotNull
    private Pair<Point, Short> guessPosition() {
        boolean p2Ok;
        JRootPane rootPane = this.myParentEditor.getContentComponent().getRootPane();
        JComponent layeredPane = rootPane != null ? rootPane.getLayeredPane() : this.myParentEditor.getComponent();
        LogicalPosition logicalPosition = this.myParentEditor.getCaretModel().getLogicalPosition();
        LogicalPosition pos = new LogicalPosition(logicalPosition.line, logicalPosition.column);
        Point p1 = HintManagerImpl.getHintPosition(this, this.myParentEditor, pos, (short)2);
        Point p2 = HintManagerImpl.getHintPosition(this, this.myParentEditor, pos, (short)1);
        boolean p1Ok = p1.y + this.getComponent().getPreferredSize().height < layeredPane.getHeight();
        boolean bl = p2Ok = p2.y >= 0;
        if (p1Ok) {
            Pair pair2 = new Pair((Object)p1, (Object)2);
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "guessPosition"));
            }
            return pair2;
        }
        if (p2Ok) {
            Pair pair3 = new Pair((Object)p2, (Object)1);
            if (pair3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "guessPosition"));
            }
            return pair3;
        }
        int aboveSpace = p2.y;
        int underSpace = layeredPane.getHeight() - p1.y;
        Pair pair4 = aboveSpace > underSpace ? new Pair((Object)new Point(p2.x, 0), (Object)2) : new Pair((Object)p1, (Object)1);
        if (pair4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/EmmetPreviewHint", "guessPosition"));
        }
        return pair4;
    }
}

