/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.google.common.base.Strings;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.LoremNode;
import com.intellij.codeInsight.template.emmet.nodes.MoreOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.MulOperationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.StringLiteralToken;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEmmetParser
extends EmmetParser {
    public static final String DEFAULT_ATTRIBUTE_NAME = "%default";
    public static final String BOOLEAN_ATTRIBUTE_VALUE = "%boolean";
    private static final String DEFAULT_TAG = "div";
    private static final int DEFAULT_LOREM_LENGTH = 30;
    private static final Pattern LOREM_PATTERN = Pattern.compile("(lorem|lipsum)(\\d*)");
    @NonNls
    private static final String DEFAULT_INLINE_TAG = "span";
    @NonNls
    private static final String LOREM_KEYWORD = "lorem";
    @NonNls
    private static final String LIPSUM_KEYWORD = "lipsum";
    private boolean hasTagContext = false;
    private final Stack<String> tagLevel = new Stack();
    private static final Map<String, String> parentChildTagMapping = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"p", (Object)"span"), (Pair[])new Pair[]{Pair.pair((Object)"ul", (Object)"li"), Pair.pair((Object)"ol", (Object)"li"), Pair.pair((Object)"table", (Object)"tr"), Pair.pair((Object)"tr", (Object)"td"), Pair.pair((Object)"tbody", (Object)"tr"), Pair.pair((Object)"thead", (Object)"tr"), Pair.pair((Object)"tfoot", (Object)"tr"), Pair.pair((Object)"colgroup", (Object)"col"), Pair.pair((Object)"select", (Object)"option"), Pair.pair((Object)"optgroup", (Object)"option"), Pair.pair((Object)"audio", (Object)"source"), Pair.pair((Object)"video", (Object)"source"), Pair.pair((Object)"object", (Object)"param"), Pair.pair((Object)"map", (Object)"area")});
    private boolean isHtml;

    public XmlEmmetParser(List<ZenCodingToken> tokens, CustomTemplateCallback callback, ZenCodingGenerator generator, boolean surroundWithTemplate) {
        super(tokens, callback, generator);
        PsiElement context = callback.getContext();
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (surroundWithTemplate && parentTag != null && context.getNode().getElementType() == XmlTokenType.XML_START_TAG_START) {
            parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentTag, XmlTag.class);
        }
        this.isHtml = generator.isHtml(callback);
        if (parentTag != null) {
            this.hasTagContext = true;
            this.tagLevel.push((Object)parentTag.getName());
        }
    }

    @Nullable
    private String parseAttributeName() {
        String name2 = "";
        ZenCodingToken token = this.getToken();
        while (token != null) {
            if (token instanceof IdentifierToken) {
                name2 = name2 + ((IdentifierToken)token).getText();
            } else {
                if (!(token instanceof OperationToken) || ((OperationToken)token).getSign() != '+' && ((OperationToken)token).getSign() != '-') break;
                name2 = name2 + ((OperationToken)token).getSign();
            }
            this.advance();
            token = this.getToken();
        }
        if (name2.isEmpty()) {
            return null;
        }
        XmlTag tag = XmlElementFactory.getInstance((Project)this.myCallback.getProject()).createTagFromText((CharSequence)("<tag " + name2 + "=''/>"), StdLanguages.HTML);
        XmlAttribute[] attributes = tag.getAttributes();
        if (attributes.length == 1) {
            return attributes[0].getName();
        }
        return null;
    }

    @NotNull
    private static String getAttributeValueByToken(@Nullable ZenCodingToken token) {
        if (token == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return "";
        }
        if (token instanceof StringLiteralToken) {
            String text2 = ((StringLiteralToken)token).getText();
            String string = text2.substring(1, text2.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof TextToken) {
            String string = ((TextToken)token).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof IdentifierToken) {
            String string = ((IdentifierToken)token).getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token instanceof NumberToken) {
            String string = Integer.toString(((NumberToken)token).getNumber());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if (token == ZenCodingTokens.DOT || token == ZenCodingTokens.SHARP) {
            String string = token.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getAttributeValueByToken"));
        }
        return "";
    }

    @Override
    @Nullable
    protected ZenCodingNode parseTemplate() {
        ZenCodingToken token = this.getToken();
        String templateKey = this.getDefaultTemplateKey();
        boolean mustHaveSelector = true;
        if (token instanceof IdentifierToken) {
            templateKey = ((IdentifierToken)token).getText();
            this.advance();
            if (StringUtil.startsWithIgnoreCase((String)templateKey, (String)LOREM_KEYWORD) || StringUtil.startsWithIgnoreCase((String)templateKey, (String)LIPSUM_KEYWORD)) {
                return this.parseLorem(templateKey);
            }
            mustHaveSelector = false;
        }
        if (templateKey == null) {
            return null;
        }
        boolean forceSingleTag = false;
        TemplateImpl template = this.myCallback.findApplicableTemplate(templateKey);
        if (template == null && StringUtil.endsWithChar((CharSequence)templateKey, (char)'/')) {
            forceSingleTag = true;
            templateKey = StringUtil.trimEnd((String)templateKey, (char)'/');
        }
        if (template == null && !ZenCodingUtil.isXML11ValidQName(templateKey) && !StringUtil.containsChar((String)templateKey, (char)'$')) {
            return null;
        }
        Map<String, String> attributes = this.parseSelectors();
        if (mustHaveSelector && attributes.isEmpty()) {
            return null;
        }
        TemplateToken templateToken = new TemplateToken(templateKey, attributes, forceSingleTag);
        if (!this.setTemplate(templateToken, template)) {
            return null;
        }
        return new TemplateNode(templateToken, this.myGenerator);
    }

    @Override
    protected ZenCodingNode parseClimbUpOperation(@Nullable ZenCodingNode leftPart) {
        this.popTagLevel();
        return super.parseClimbUpOperation(leftPart);
    }

    @Override
    protected ZenCodingNode parseMoreOperation(@Nullable ZenCodingNode leftPart) {
        ZenCodingNode result2;
        String parentTag = XmlEmmetParser.getParentTag(leftPart);
        boolean hasParent = false;
        if (!Strings.isNullOrEmpty((String)parentTag)) {
            hasParent = true;
            this.tagLevel.push((Object)parentTag);
        }
        if ((result2 = super.parseMoreOperation(leftPart)) == null) {
            return null;
        }
        if (hasParent) {
            this.popTagLevel();
        }
        return result2;
    }

    @Nullable
    private String getDefaultTemplateKey() {
        return this.isHtml ? this.suggestTagName() : null;
    }

    @Nullable
    private static String getParentTag(ZenCodingNode node) {
        ZenCodingNode leftOperand2;
        if (node instanceof TemplateNode) {
            return ((TemplateNode)node).getTemplateToken().getKey();
        }
        if (node instanceof MulOperationNode && (leftOperand2 = ((MulOperationNode)node).getLeftOperand()) instanceof TemplateNode) {
            return ((TemplateNode)leftOperand2).getTemplateToken().getKey();
        }
        return null;
    }

    @Nullable
    private ZenCodingNode parseLorem(String templateKey) {
        Matcher matcher = LOREM_PATTERN.matcher(templateKey);
        if (matcher.matches()) {
            boolean isRepeating;
            int loremWordsCount = 30;
            if (matcher.groupCount() > 1) {
                String group = matcher.group(2);
                loremWordsCount = group == null || group.isEmpty() ? 30 : Integer.parseInt(group);
            }
            Map<String, String> attributes = this.parseSelectors();
            ZenCodingToken token = this.getToken();
            boolean bl = isRepeating = token instanceof OperationToken && ((OperationToken)token).getSign() == '*';
            if (!attributes.isEmpty() || isRepeating) {
                String wrapTag = this.suggestTagName();
                TemplateImpl template = this.myCallback.findApplicableTemplate(templateKey);
                if (template == null && !ZenCodingUtil.isXML11ValidQName(templateKey)) {
                    return null;
                }
                TemplateToken templateToken = new TemplateToken(wrapTag, attributes);
                if (!this.setTemplate(templateToken, template)) {
                    return null;
                }
                return new MoreOperationNode(new TemplateNode(templateToken), new LoremNode(loremWordsCount));
            }
            return new LoremNode(loremWordsCount);
        }
        return null;
    }

    private String suggestTagName() {
        if (!this.tagLevel.empty()) {
            String parentTag = (String)this.tagLevel.peek();
            if (parentChildTagMapping.containsKey(parentTag)) {
                return parentChildTagMapping.get(parentTag);
            }
            if (HtmlUtil.isPossiblyInlineTag(parentTag)) {
                return DEFAULT_INLINE_TAG;
            }
        }
        return DEFAULT_TAG;
    }

    private void popTagLevel() {
        if (this.tagLevel.size() > (this.hasTagContext ? 1 : 0)) {
            this.tagLevel.pop();
        }
    }

    @NotNull
    private Map<String, String> parseSelectors() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        List<Couple<String>> attrList = this.parseSelector();
        while (attrList != null) {
            for (Couple<String> attr : attrList) {
                if (this.getClassAttributeName().equals(attr.first)) {
                    result2.put(this.getClassAttributeName(), (StringUtil.notNullize((String)((String)result2.get(this.getClassAttributeName()))) + " " + (String)attr.second).trim());
                    continue;
                }
                if ("id".equals(attr.first)) {
                    result2.put("id", (StringUtil.notNullize((String)((String)result2.get("id"))) + " " + (String)attr.second).trim());
                    continue;
                }
                result2.put(attr.first, attr.second);
            }
            attrList = this.parseSelector();
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "parseSelectors"));
        }
        return linkedHashMap;
    }

    @Nullable
    private List<Couple<String>> parseSelector() {
        ZenCodingToken token = this.getToken();
        if (token == ZenCodingTokens.OPENING_SQ_BRACKET) {
            this.advance();
            List<Couple<String>> attrList = this.parseAttributeList();
            if (this.getToken() != ZenCodingTokens.CLOSING_SQ_BRACKET) {
                return null;
            }
            this.advance();
            return attrList;
        }
        if (token == ZenCodingTokens.DOT || token == ZenCodingTokens.SHARP) {
            String name2 = token == ZenCodingTokens.DOT ? this.getClassAttributeName() : "id";
            this.advance();
            token = this.getToken();
            String value2 = XmlEmmetParser.getAttributeValueByToken(token);
            if (!value2.isEmpty()) {
                this.advance();
            }
            return Collections.singletonList(Couple.of((Object)name2, (Object)value2));
        }
        return null;
    }

    @NotNull
    protected String getClassAttributeName() {
        if ("class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "getClassAttributeName"));
        }
        return "class";
    }

    @NotNull
    private List<Couple<String>> parseAttributeList() {
        ArrayList<Couple<String>> result2 = new ArrayList<Couple<String>>();
        while (true) {
            Couple<String> attribute;
            if ((attribute = this.parseAttribute()) == null) {
                ArrayList<Couple<String>> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "parseAttributeList"));
                }
                return arrayList;
            }
            result2.add(attribute);
            ZenCodingToken token = this.getToken();
            if (token != ZenCodingTokens.COMMA && token != ZenCodingTokens.SPACE) {
                ArrayList<Couple<String>> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "parseAttributeList"));
                }
                return arrayList;
            }
            this.advance();
        }
    }

    @Nullable
    private Couple<String> parseAttribute() {
        int position = this.getCurrentPosition();
        String attributeName = this.parseAttributeName();
        if (attributeName != null && !attributeName.isEmpty()) {
            if (this.getToken() == ZenCodingTokens.DOT) {
                if (XmlEmmetParser.isEndOfAttribute(this.nextToken(1))) {
                    this.advance();
                    return Couple.of((Object)attributeName, (Object)BOOLEAN_ATTRIBUTE_VALUE);
                }
            } else {
                if (this.getToken() == ZenCodingTokens.EQ) {
                    this.advance();
                    return Couple.of((Object)attributeName, (Object)this.parseAttributeValue());
                }
                return Couple.of((Object)attributeName, (Object)"");
            }
        }
        this.restorePosition(position);
        String impliedValue = this.parseAttributeValue();
        if (!impliedValue.isEmpty()) {
            return Couple.of((Object)DEFAULT_ATTRIBUTE_NAME, (Object)impliedValue);
        }
        return null;
    }

    @NotNull
    private String parseAttributeValue() {
        ZenCodingToken token;
        StringBuilder attrValueBuilder = new StringBuilder();
        do {
            token = this.getToken();
            String value2 = XmlEmmetParser.getAttributeValueByToken(token);
            attrValueBuilder.append(value2);
            if (XmlEmmetParser.isEndOfAttribute(token)) continue;
            this.advance();
        } while (!XmlEmmetParser.isEndOfAttribute(token));
        String string = attrValueBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/XmlEmmetParser", "parseAttributeValue"));
        }
        return string;
    }

    private static boolean isEndOfAttribute(@Nullable ZenCodingToken nextToken) {
        return nextToken == null || nextToken == ZenCodingTokens.SPACE || nextToken == ZenCodingTokens.CLOSING_SQ_BRACKET || nextToken == ZenCodingTokens.COMMA;
    }
}

