/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.actions;

import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;

public class EmmetEditPointUtil {
    public static void moveForward(Editor editor, PsiFile file2) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor, file2, editor.getCaretModel().getOffset(), 1);
    }

    public static void moveBackward(Editor editor, PsiFile file2) {
        if (!XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            return;
        }
        EmmetEditPointUtil.moveToNextPoint(editor, file2, editor.getCaretModel().getOffset(), -1);
    }

    private static void moveToNextPoint(Editor editor, PsiFile file2, int offset, int inc) {
        Document doc = editor.getDocument();
        TemplateLanguageFileViewProvider provider = (TemplateLanguageFileViewProvider)ObjectUtils.tryCast((Object)file2.getViewProvider(), TemplateLanguageFileViewProvider.class);
        Language additionalLanguage = provider != null ? provider.getTemplateDataLanguage() : null;
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(doc);
        for (int i2 = offset + inc; i2 < doc.getTextLength() && i2 >= 0; i2 += inc) {
            PsiElement current = InjectedLanguageUtil.findElementAtNoCommit(file2, i2);
            if (EmmetEditPointUtil.checkAndMove(editor, doc, i2, current)) {
                return;
            }
            if (additionalLanguage == null || !EmmetEditPointUtil.checkAndMove(editor, doc, i2, current = provider.findElementAt(i2, additionalLanguage))) continue;
            return;
        }
    }

    private static boolean checkAndMove(Editor editor, Document doc, int offset, PsiElement current) {
        if (current == null) {
            return false;
        }
        if (current.getParent() instanceof XmlText) {
            int line = doc.getLineNumber(offset);
            int lineStart = doc.getLineStartOffset(line);
            int lineEnd = doc.getLineEndOffset(line);
            CharSequence text2 = doc.getCharsSequence().subSequence(lineStart, lineEnd);
            if (StringUtil.isEmptyOrSpaces((CharSequence)text2) && EmmetEditPointUtil.moveCaret(editor, current, lineEnd)) {
                return true;
            }
        } else if (EmmetEditPointUtil.isEmptyEditPoint(current) && EmmetEditPointUtil.moveCaret(editor, current, current.getTextRange().getStartOffset())) {
            return true;
        }
        return false;
    }

    private static boolean moveCaret(Editor editor, PsiElement current, int offset) {
        CaretModel caretModel = (editor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, current.getContainingFile())).getCaretModel();
        if (caretModel.getOffset() == offset) {
            return false;
        }
        caretModel.moveToOffset(offset);
        Caret caret = caretModel.getCurrentCaret();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (caret == caretModel.getPrimaryCaret()) {
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
        }
        return true;
    }

    private static boolean isEmptyEditPoint(PsiElement element) {
        IElementType type2 = element.getNode().getElementType();
        if (type2 == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
            return prev != null && prev.getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
        }
        if (type2 == XmlTokenType.XML_END_TAG_START || type2 == XmlTokenType.XML_START_TAG_START) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
            return prev != null && prev.getNode().getElementType() == XmlTokenType.XML_TAG_END;
        }
        return false;
    }
}

