/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.editorActions.XmlEditUtil;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.html.HtmlQuotesFormatPreprocessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.DocumentUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlZenCodingGenerator
extends ZenCodingGenerator {
    @Override
    public TemplateImpl generateTemplate(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "generateTemplate"));
        }
        String s = this.toString(token, hasChildren, context);
        TemplateImpl tokenTemplate = token.getTemplate();
        assert (tokenTemplate != null);
        TemplateImpl template = tokenTemplate.copy();
        template.setString(s);
        return template;
    }

    @Override
    public TemplateImpl createTemplateByKey(@NotNull String key2, boolean forceSingleTag) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "createTemplateByKey"));
        }
        StringBuilder builder = new StringBuilder("<");
        builder.append(key2).append('>');
        if (!forceSingleTag && !HtmlUtil.isSingleHtmlTag(key2)) {
            builder.append("$END$</").append(key2).append('>');
        }
        return new TemplateImpl("", builder.toString(), "");
    }

    @NotNull
    private String toString(@NotNull TemplateToken token, boolean hasChildren, @NotNull PsiElement context) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        CodeStyleSettings.QuoteStyle quoteStyle = XmlEditUtil.quoteStyle(context.getContainingFile());
        XmlTag tag = token.getXmlTag();
        if (tag != null) {
            if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
                DocumentUtil.writeInRunUndoTransparentAction(() -> HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, (PsiElement)tag));
            }
            String string = XmlZenCodingGenerator.replaceQuotesIfNeeded(this.toString(tag, token.getAttributes(), hasChildren, context), context.getContainingFile());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
            }
            return string;
        }
        PsiFile file2 = token.getFile();
        if (quoteStyle != CodeStyleSettings.QuoteStyle.None) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> HtmlQuotesFormatPreprocessor.HtmlQuotesConverter.runOnElement(quoteStyle, (PsiElement)file2));
        }
        String string = XmlZenCodingGenerator.replaceQuotesIfNeeded(file2.getText(), context.getContainingFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "toString"));
        }
        return string;
    }

    private static String replaceQuotesIfNeeded(@NotNull String text2, @NotNull PsiFile file2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "replaceQuotesIfNeeded"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "replaceQuotesIfNeeded"));
        }
        PsiElement context = file2.getContext();
        if (context != null) {
            String contextText = context.getText();
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\"')) {
                return StringUtil.escapeChar((String)text2, (char)'\"');
            }
            if (StringUtil.startsWithChar((CharSequence)contextText, (char)'\'')) {
                return StringUtil.escapeChar((String)text2, (char)'\'');
            }
        }
        return text2;
    }

    public abstract String toString(@NotNull XmlTag var1, @NotNull Map<String, String> var2, boolean var3, @NotNull PsiElement var4);

    @NotNull
    public abstract String buildAttributesString(@NotNull Map<String, String> var1, boolean var2, int var3, int var4, @Nullable String var5);

    @Override
    public abstract boolean isMyContext(@NotNull PsiElement var1, boolean var2);

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "computeTemplateKey"));
        }
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        int startOffset = Math.min(editor.getDocument().getLineStartOffset(editor.getDocument().getLineNumber(currentOffset)), currentOffset);
        CharSequence documentText = editor.getDocument().getCharsSequence();
        PsiElement prevVisibleLeaf = callback.getContext();
        while (prevVisibleLeaf != null) {
            TextRange textRange = prevVisibleLeaf.getTextRange();
            int endOffset = textRange.getEndOffset();
            if (endOffset <= currentOffset) {
                if (endOffset <= startOffset) break;
                IElementType prevType = prevVisibleLeaf.getNode().getElementType();
                if (prevType == XmlTokenType.XML_TAG_END || prevType == XmlTokenType.XML_EMPTY_ELEMENT_END) {
                    startOffset = endOffset;
                    break;
                }
            }
            prevVisibleLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)prevVisibleLeaf);
        }
        if (startOffset < 0 || currentOffset > documentText.length() || currentOffset < startOffset) {
            Logger.getInstance(this.getClass()).error("Error while calculating emmet abbreviation. Offset: " + currentOffset + "; Start: " + startOffset, new Attachment[]{AttachmentFactory.createAttachment(editor.getDocument())});
            return null;
        }
        String key2 = this.computeKey(documentText.subSequence(startOffset, currentOffset));
        return !StringUtil.isEmpty((String)key2) && ZenCodingTemplate.checkTemplateKey(key2, callback, this) ? key2 : null;
    }

    @Override
    public void disableEmmet() {
        EmmetOptions.getInstance().setEmmetEnabled(false);
    }

    @Override
    public boolean isHtml(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGenerator", "isHtml"));
        }
        return ZenCodingUtil.isHtml(callback);
    }
}

