/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl.editorActions;

import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class EnterHandler
extends BaseEnterHandler {
    private final EditorActionHandler myOriginalHandler;

    public EnterHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/editorActions/EnterHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/template/impl/editorActions/EnterHandler", "isEnabledForCaret"));
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        Project project2 = editor.getProject();
        if (project2 != null && TemplateManager.getInstance(project2).startTemplate(editor, '\n')) {
            return;
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }
}

