/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class PostfixTemplatesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    PostfixTemplatesCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "addCompletions"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "addCompletions"));
        }
        Editor editor = parameters2.getEditor();
        if (!PostfixTemplatesCompletionProvider.isCompletionEnabled(parameters2) || LiveTemplateCompletionContributor.shouldShowAllTemplates() || editor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        PsiFile originalFile = parameters2.getOriginalFile();
        PostfixLiveTemplate postfixLiveTemplate = PostfixTemplateCompletionContributor.getPostfixLiveTemplate(originalFile, editor);
        if (postfixLiveTemplate != null) {
            postfixLiveTemplate.addCompletions(parameters2, result2.withPrefixMatcher((PrefixMatcher)new MyPrefixMatcher(result2.getPrefixMatcher().getPrefix())));
            String possibleKey = postfixLiveTemplate.computeTemplateKeyWithoutContextChecking(new CustomTemplateCallback(editor, originalFile));
            if (possibleKey != null) {
                result2 = result2.withPrefixMatcher(possibleKey);
                result2.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().oneOf(postfixLiveTemplate.getAllTemplateKeys(originalFile, parameters2.getOffset())));
            }
        }
    }

    private static boolean isCompletionEnabled(@NotNull CompletionParameters parameters2) {
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "isCompletionEnabled"));
        }
        if (!parameters2.isAutoPopup()) {
            return false;
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplatesCompletionEnabled();
    }

    private static class MyPrefixMatcher
    extends PrefixMatcher {
        protected MyPrefixMatcher(String prefix) {
            super(prefix);
        }

        public boolean prefixMatches(@NotNull String name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher", "prefixMatches"));
            }
            return name2.equalsIgnoreCase(this.myPrefix);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher", "cloneWithPrefix"));
            }
            MyPrefixMatcher myPrefixMatcher = new MyPrefixMatcher(prefix);
            if (myPrefixMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider$MyPrefixMatcher", "cloneWithPrefix"));
            }
            return myPrefixMatcher;
        }
    }
}

