/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LanguagePostfixTemplate
extends LanguageExtension<PostfixTemplateProvider> {
    private static final Logger LOG = Logger.getInstance(LanguagePostfixTemplate.class);
    public static final LanguagePostfixTemplate LANG_EP = new LanguagePostfixTemplate();
    public static final String EP_NAME = "com.intellij.codeInsight.template.postfixTemplateProvider";

    private LanguagePostfixTemplate() {
        super(EP_NAME);
    }

    @NotNull
    protected List<PostfixTemplateProvider> buildExtensions(@NotNull String stringKey, @NotNull Language key2) {
        if (stringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringKey", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        List providers2 = super.buildExtensions(stringKey, (Object)key2);
        LanguagePostfixTemplate.validateTemplatesForLanguage(key2, providers2);
        List list2 = providers2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        return list2;
    }

    private static void validateTemplatesForLanguage(Language key2, List<PostfixTemplateProvider> providers2) {
        HashMap templateKeys = ContainerUtil.newHashMap();
        for (PostfixTemplateProvider provider : providers2) {
            for (PostfixTemplate template : provider.getTemplates()) {
                PostfixTemplateProvider oldProvider = templateKeys.put(template.getKey(), provider);
                if (oldProvider == null) continue;
                String oldPlugin = LanguagePostfixTemplate.getPluginId(oldProvider);
                String newPlugin = LanguagePostfixTemplate.getPluginId(provider);
                LOG.error("Duplicated postfix completion key '" + template.getKey() + "' for language " + key2.getID() + ". Possible you need to disable one of the plugins: " + oldPlugin + ", " + newPlugin);
            }
        }
    }

    @NotNull
    private static String getPluginId(@NotNull PostfixTemplateProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "getPluginId"));
        }
        ClassLoader loader = provider.getClass().getClassLoader();
        if (loader instanceof PluginClassLoader) {
            String string = ((PluginClassLoader)((Object)loader)).getPluginId().getIdString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "getPluginId"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "getPluginId"));
        }
        return "";
    }
}

