/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.util.IncorrectOperationException;

public class JavaTryUnwrapper
extends JavaUnwrapper {
    public JavaTryUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.try", (Object[])new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return e instanceof PsiTryStatement;
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiTryStatement trySt = (PsiTryStatement)element;
        PsiResourceList resourceList = trySt.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement listElement : resourceList) {
                if (!(listElement instanceof PsiResourceVariable)) continue;
                context.extractElement((PsiElement)listElement, (PsiElement)trySt);
                if (!context.myIsEffective) continue;
                PsiStatement emptyStatement = JavaPsiFacade.getElementFactory((Project)resourceList.getProject()).createStatementFromText(";", (PsiElement)trySt);
                trySt.getParent().addBefore((PsiElement)emptyStatement, (PsiElement)trySt);
            }
        }
        context.extractFromCodeBlock(trySt.getTryBlock(), (PsiElement)trySt);
        context.extractFromCodeBlock(trySt.getFinallyBlock(), (PsiElement)trySt);
        context.delete((PsiElement)trySt);
    }
}

