/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InspectionApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.InspectionApplication");
    public InspectionToolCmdlineOptionHelpProvider myHelpProvider = null;
    public String myProjectPath = null;
    public String myOutPath = null;
    public String mySourceDirectory = null;
    public String myStubProfile = null;
    public String myProfileName = null;
    public String myProfilePath = null;
    public boolean myRunWithEditorSettings = false;
    public boolean myRunGlobalToolsOnly = false;
    private Project myProject;
    private int myVerboseLevel = 0;
    public String myOutputFormat = null;
    public boolean myErrorCodeRequired = true;
    @NonNls
    public static final String DESCRIPTIONS = ".descriptions";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    public static final String INSPECTIONS_NODE = "inspections";
    @NonNls
    public static final String XML_EXTENSION = ".xml";

    public void startup() {
        if (this.myProjectPath == null) {
            InspectionApplication.logError("Project to inspect is not defined");
            this.printHelp();
        }
        if (this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null) {
            InspectionApplication.logError("Profile to inspect with is not defined");
            this.printHelp();
        }
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.runReadAction(() -> {
            try {
                ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
                this.logMessage(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
                application.doNotSave();
                this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
                this.run();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                if (this.myErrorCodeRequired) {
                    application.exit(true, true);
                }
            }
        });
    }

    private void printHelp() {
        assert (this.myHelpProvider != null);
        this.myHelpProvider.printHelpAndExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run() {
        File tmpDir = null;
        try {
            String resultsDataPath;
            InspectionsReportConverter reportConverter;
            AnalysisScope scope;
            this.myProjectPath = this.myProjectPath.replace(File.separatorChar, '/');
            VirtualFile vfsProject = LocalFileSystem.getInstance().findFileByPath(this.myProjectPath);
            if (vfsProject == null) {
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{this.myProjectPath}));
                this.printHelp();
            }
            this.logMessage(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
            ConversionService conversionService = ConversionService.getInstance();
            if (conversionService.convertSilently(this.myProjectPath, this.createConversionListener()).openingIsCanceled()) {
                this.gracefulExit();
                return;
            }
            this.myProject = ProjectUtil.openOrImport(this.myProjectPath, null, false);
            if (this.myProject == null) {
                InspectionApplication.logError("Unable to open project");
                this.gracefulExit();
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
            PatchProjectUtil.patchProject(this.myProject);
            this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
            this.logMessage(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
            InspectionProfileImpl inspectionProfile = this.loadInspectionProfile();
            if (inspectionProfile == null) {
                return;
            }
            InspectionManagerEx im = (InspectionManagerEx)InspectionManager.getInstance((Project)this.myProject);
            im.createNewGlobalContext(true).setExternalProfile(inspectionProfile);
            im.setProfile(inspectionProfile.getName());
            if (this.mySourceDirectory == null) {
                String scopeName = System.getProperty("idea.analyze.scope");
                NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)this.myProject, (String)scopeName) : null;
                scope = namedScope != null ? new AnalysisScope((SearchScope)GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope), this.myProject) : new AnalysisScope(this.myProject);
            } else {
                this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
                VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
                if (vfsDir == null) {
                    InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                    this.printHelp();
                }
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(vfsDir);
                scope = new AnalysisScope(psiDirectory);
            }
            this.logMessageLn(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
            if (!this.myRunWithEditorSettings) {
                this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
            }
            if ((reportConverter = InspectionApplication.getReportConverter(this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
                reportConverter = new XSLTReportConverter(this.myOutputFormat);
            }
            if (!(reportConverter != null && reportConverter.useTmpDirForRawData() || this.myOutPath == null)) {
                resultsDataPath = this.myOutPath;
            } else {
                try {
                    tmpDir = FileUtil.createTempDirectory((String)INSPECTIONS_NODE, (String)"data");
                    resultsDataPath = tmpDir.getPath();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    System.err.println("Cannot create tmp directory.");
                    System.exit(1);
                    if (tmpDir == null) return;
                    FileUtil.delete((File)tmpDir);
                    return;
                }
            }
            ArrayList<File> inspectionsResults = new ArrayList<File>();
            ProgressManager.getInstance().runProcess(() -> {
                if (!GlobalInspectionContextUtil.canRunInspections(this.myProject, false)) {
                    this.gracefulExit();
                    return;
                }
                im.createNewGlobalContext(true).launchInspectionsOffline(scope, resultsDataPath, this.myRunGlobalToolsOnly, inspectionsResults);
                this.logMessageLn(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
                if (!this.myErrorCodeRequired) {
                    this.closeProject();
                }
            }, (ProgressIndicator)new ProgressIndicatorBase(){
                private String lastPrefix = "";
                private int myLastPercent = -1;

                @Override
                public void setText(String text2) {
                    if (InspectionApplication.this.myVerboseLevel == 0) {
                        return;
                    }
                    if (InspectionApplication.this.myVerboseLevel == 1) {
                        String prefix = InspectionApplication.getPrefix(text2);
                        if (prefix == null) {
                            return;
                        }
                        if (prefix.equals(this.lastPrefix)) {
                            InspectionApplication.this.logMessage(1, ".");
                            return;
                        }
                        this.lastPrefix = prefix;
                        InspectionApplication.this.logMessageLn(1, "");
                        InspectionApplication.this.logMessageLn(1, prefix);
                        return;
                    }
                    if (InspectionApplication.this.myVerboseLevel == 3) {
                        if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                            int percent = (int)(this.getFraction() * 100.0);
                            if (this.myLastPercent == percent) {
                                return;
                            }
                            String prefix = InspectionApplication.getPrefix(text2);
                            this.myLastPercent = percent;
                            String msg = (prefix != null ? prefix : InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])) + " " + percent + "%";
                            InspectionApplication.this.logMessageLn(2, msg);
                        }
                        return;
                    }
                    InspectionApplication.this.logMessageLn(2, text2);
                }
            });
            String descriptionsFile = resultsDataPath + File.separatorChar + DESCRIPTIONS + XML_EXTENSION;
            InspectionApplication.describeInspections(descriptionsFile, this.myRunWithEditorSettings ? null : inspectionProfile.getName(), inspectionProfile);
            inspectionsResults.add(new File(descriptionsFile));
            if (reportConverter != null) {
                try {
                    reportConverter.convert(resultsDataPath, this.myOutPath, im.createNewGlobalContext(true).getTools(), inspectionsResults);
                }
                catch (InspectionsReportConverter.ConversionException e) {
                    InspectionApplication.logError("\n" + e.getMessage());
                    this.printHelp();
                }
            }
            if (tmpDir == null) return;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            InspectionApplication.logError(e.getMessage());
            this.printHelp();
            return;
        }
        catch (Throwable e) {
            LOG.error(e);
            InspectionApplication.logError(e.getMessage());
            this.gracefulExit();
            return;
        }
        finally {
            if (tmpDir != null) {
                FileUtil.delete(tmpDir);
            }
        }
        FileUtil.delete((File)tmpDir);
        return;
    }

    private void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            this.closeProject();
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private void closeProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            ProjectUtil.closeAndDispose(this.myProject);
            this.myProject = null;
        }
    }

    @Nullable
    private InspectionProfileImpl loadInspectionProfile() throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile = null;
        if (this.myProfileName != null) {
            inspectionProfile = this.loadProfileByName(this.myProfileName);
            if (inspectionProfile == null) {
                InspectionApplication.logError("Profile with configured name (" + this.myProfileName + ") was not found (neither in project nor in config directory)");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myProfilePath != null) {
            inspectionProfile = this.loadProfileByPath(this.myProfilePath);
            if (inspectionProfile == null) {
                InspectionApplication.logError("Failed to load profile from '" + this.myProfilePath + "'");
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (this.myStubProfile != null) {
            if (!this.myRunWithEditorSettings) {
                inspectionProfile = this.loadProfileByName(this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
                inspectionProfile = this.loadProfileByPath(this.myStubProfile);
                if (inspectionProfile != null) {
                    return inspectionProfile;
                }
            }
            inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
            InspectionApplication.logError("Using default project profile");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByPath(String profilePath) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile = ApplicationInspectionProfileManager.getInstanceImpl().loadProfile(profilePath);
        if (inspectionProfile != null) {
            this.logMessageLn(1, "Loaded profile '" + inspectionProfile.getName() + "' from file '" + profilePath + "'");
        }
        return inspectionProfile;
    }

    @Nullable
    private InspectionProfileImpl loadProfileByName(String profileName) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance(this.myProject).getProfile(profileName, false);
        if (inspectionProfile != null) {
            this.logMessageLn(1, "Loaded shared project profile '" + profileName + "'");
        } else {
            for (InspectionProfileImpl profile2 : InspectionProjectProfileManager.getInstance(this.myProject).getProfiles()) {
                if (!Comparing.strEqual((String)profile2.getName(), (String)profileName)) continue;
                inspectionProfile = profile2;
                this.logMessageLn(1, "Loaded local profile '" + profileName + "'");
                break;
            }
        }
        return inspectionProfile;
    }

    @Nullable
    private static InspectionsReportConverter getReportConverter(@Nullable String outputFormat) {
        for (InspectionsReportConverter converter : (InspectionsReportConverter[])InspectionsReportConverter.EP_NAME.getExtensions()) {
            if (!converter.getFormatName().equals(outputFormat)) continue;
            return converter;
        }
        return null;
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(File backupDir) {
                InspectionApplication.this.logMessageLn(1, InspectionsBundle.message((String)"inspection.application.project.was.succesfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.getAbsolutePath()}));
            }

            @Override
            public void error(String message2) {
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message2}));
            }

            @Override
            public void cannotWriteToFiles(List<File> readonlyFiles) {
                StringBuilder files = new StringBuilder();
                for (File file2 : readonlyFiles) {
                    files.append(file2.getAbsolutePath()).append("; ");
                }
                InspectionApplication.logError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files.toString()}));
            }
        };
    }

    @Nullable
    private static String getPrefix(String text2) {
        int idx = text2.indexOf(" in ");
        if (idx == -1) {
            idx = text2.indexOf(" of ");
        }
        return idx == -1 ? null : text2.substring(0, idx);
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void logMessage(int minVerboseLevel, String message2) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message2);
        }
    }

    private static void logError(String message2) {
        System.err.println(message2);
    }

    private void logMessageLn(int minVerboseLevel, String message2) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void describeInspections(@NonNls String myOutputPath, String name2, InspectionProfile profile2) throws IOException {
        InspectionToolWrapper[] toolWrappers = profile2.getInspectionTools(null);
        HashMap<String, HashSet<InspectionToolWrapper>> map2 = new HashMap<String, HashSet<InspectionToolWrapper>>();
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            String groupName = toolWrapper.getGroupDisplayName();
            HashSet<InspectionToolWrapper> groupInspections = (HashSet<InspectionToolWrapper>)map2.get(groupName);
            if (groupInspections == null) {
                groupInspections = new HashSet<InspectionToolWrapper>();
                map2.put(groupName, groupInspections);
            }
            groupInspections.add(toolWrapper);
        }
        try (FileWriter fw = new FileWriter(myOutputPath);){
            PrettyPrintWriter xmlWriter = new PrettyPrintWriter((Writer)fw);
            xmlWriter.startNode(INSPECTIONS_NODE);
            if (name2 != null) {
                xmlWriter.addAttribute(PROFILE, name2);
            }
            for (String groupName : map2.keySet()) {
                xmlWriter.startNode("group");
                xmlWriter.addAttribute("name", groupName);
                Set entries = (Set)map2.get(groupName);
                for (InspectionToolWrapper toolWrapper : entries) {
                    xmlWriter.startNode("inspection");
                    String shortName = toolWrapper.getShortName();
                    xmlWriter.addAttribute("shortName", shortName);
                    xmlWriter.addAttribute("displayName", toolWrapper.getDisplayName());
                    boolean toolEnabled = profile2.isToolEnabled(HighlightDisplayKey.find((String)shortName));
                    xmlWriter.addAttribute("enabled", Boolean.toString(toolEnabled));
                    String description = toolWrapper.loadDescription();
                    if (description != null) {
                        xmlWriter.setValue(description);
                    } else {
                        LOG.error(shortName + " descriptionUrl==" + toolWrapper);
                    }
                    xmlWriter.endNode();
                }
                xmlWriter.endNode();
            }
            xmlWriter.endNode();
        }
    }
}

