/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidComparatorMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement referenceNameElement = expression2.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                String name2 = referenceNameElement.getText();
                if (!name2.equals("min") && !name2.equals("max")) {
                    return;
                }
                String className = InvalidComparatorMethodReferenceInspection.getMethodReferenceClassName(expression2);
                if (!"java.lang.Integer".equals(className) && !"java.lang.Math".equals(className)) {
                    return;
                }
                String functionalInterface = InvalidComparatorMethodReferenceInspection.getFunctionalInterfaceClassName(expression2);
                if (!"java.util.Comparator".equals(functionalInterface)) {
                    return;
                }
                holder.registerProblem((PsiElement)expression2, "Method reference mapped to Comparator interface does not fulfill the Comparator contract", new LocalQuickFix[]{new ReplaceWithComparatorQuickFix(name2.equals("min"))});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    static String getFunctionalInterfaceClassName(PsiMethodReferenceExpression expression2) {
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return null;
        }
        PsiClass targetType = ((PsiClassType)functionalInterfaceType).resolve();
        if (targetType == null) {
            return null;
        }
        return targetType.getQualifiedName();
    }

    @Nullable
    static String getMethodReferenceClassName(PsiMethodReferenceExpression expression2) {
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement refType = ((PsiReference)qualifierExpression2).resolve();
        if (!(refType instanceof PsiClass)) {
            return null;
        }
        return ((PsiClass)refType).getQualifiedName();
    }

    private static class ReplaceWithComparatorQuickFix
    implements LocalQuickFix {
        private final boolean reverse;

        public ReplaceWithComparatorQuickFix(boolean reverse) {
            this.reverse = reverse;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + (this.reverse ? "Comparator.reverseOrder()" : "Comparator.naturalOrder()");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with comparator" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "getFamilyName"));
            }
            return "Replace with comparator";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent != null) {
                PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("java.util.Comparator." + (this.reverse ? "reverseOrder()" : "naturalOrder()"), parent);
                element.replace((PsiElement)newMethodExpression);
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(parent);
            }
        }
    }
}

