/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveFieldAssignmentToInitializerInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/MoveFieldAssignmentToInitializerInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
                TextRange range;
                PsiElement parent = assignment.getParent();
                if (!(parent instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiField field = MoveFieldAssignmentToInitializerInspection.getAssignedField(assignment);
                if (field == null || field.hasInitializer()) {
                    return;
                }
                PsiClass psiClass = field.getContainingClass();
                if (psiClass == null || psiClass.isInterface()) {
                    return;
                }
                if (psiClass.getContainingFile() != holder.getFile()) {
                    return;
                }
                PsiModifierListOwner ctrOrInitializer = MoveFieldAssignmentToInitializerInspection.enclosingMethodOrClassInitializer(assignment, field);
                if (ctrOrInitializer == null) {
                    return;
                }
                if (ctrOrInitializer.hasModifierProperty("static") != field.hasModifierProperty("static")) {
                    return;
                }
                if (!MoveFieldAssignmentToInitializerInspection.isValidAsFieldInitializer(assignment.getRExpression(), ctrOrInitializer, field)) {
                    return;
                }
                if (!MoveFieldAssignmentToInitializerInspection.isInitializedWithSameExpression(field, assignment, new ArrayList())) {
                    return;
                }
                boolean shouldWarn = MoveFieldAssignmentToInitializerInspection.this.shouldWarn(ctrOrInitializer, field, assignment);
                if (!shouldWarn && !isOnTheFly) {
                    return;
                }
                if (shouldWarn && !InspectionProjectProfileManager.isInformationLevel(MoveFieldAssignmentToInitializerInspection.this.getShortName(), (PsiElement)assignment)) {
                    PsiExpression lValue = assignment.getLExpression();
                    range = new TextRange(0, lValue.getTextLength()).shiftRight(lValue.getStartOffsetInParent());
                } else {
                    range = new TextRange(0, assignment.getTextLength());
                }
                holder.registerProblem((PsiElement)assignment, CodeInsightBundle.message((String)"intention.move.field.assignment.to.declaration", (Object[])new Object[0]), shouldWarn ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION, range, new LocalQuickFix[]{new MoveFieldAssignmentToInitializerFix()});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/MoveFieldAssignmentToInitializerInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    boolean shouldWarn(PsiModifierListOwner ctrOrInitializer, PsiField field, PsiAssignmentExpression assignment) {
        if (!(ctrOrInitializer instanceof PsiClassInitializer)) {
            return false;
        }
        PsiExpressionStatement statement2 = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignment.getParent(), PsiExpressionStatement.class);
        if (statement2 == null) {
            return false;
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)statement2.getParent(), PsiCodeBlock.class);
        if (codeBlock == null) {
            return false;
        }
        if (codeBlock.getParent() != ctrOrInitializer) {
            return false;
        }
        if (!ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)ctrOrInitializer)).forEach(ref -> PsiTreeUtil.isAncestor((PsiElement)assignment, (PsiElement)ref.getElement(), (boolean)true))) {
            return false;
        }
        if (((StreamEx)StreamEx.of((Object[])codeBlock.getStatements()).takeWhile(st -> statement2 != st)).allMatch(st -> ExpressionUtils.getAssignment((PsiElement)st) != null)) {
            return true;
        }
        PsiExpression value2 = assignment.getRExpression();
        return ExpressionUtils.isSimpleExpression(value2) || ConstructionUtils.isEmptyCollectionInitializer(value2);
    }

    private static boolean isValidAsFieldInitializer(final PsiExpression initializer, final PsiModifierListOwner ctrOrInitializer, final PsiField field) {
        if (initializer == null) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{initializer}).isEmpty()) {
            return false;
        }
        final Ref result2 = new Ref((Object)Boolean.TRUE);
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved == null) {
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)ctrOrInitializer, (PsiElement)resolved, (boolean)false) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolved, (boolean)false)) {
                    result2.set((Object)Boolean.FALSE);
                }
                if (resolved instanceof PsiMember && resolved != field && ((PsiMember)resolved).getContainingClass() == field.getContainingClass() && (field.hasModifierProperty("static") || !((PsiMember)resolved).hasModifierProperty("static"))) {
                    result2.set((Object)Boolean.FALSE);
                }
            }
        });
        return (Boolean)result2.get();
    }

    static PsiModifierListOwner enclosingMethodOrClassInitializer(PsiAssignmentExpression assignment, PsiField field) {
        PsiElement parent;
        PsiAssignmentExpression parentOwner = assignment;
        do {
            if ((parentOwner = PsiTreeUtil.getParentOfType((PsiElement)parentOwner, PsiModifierListOwner.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null) continue;
            return null;
        } while ((parent = parentOwner.getParent()) != field.getContainingClass());
        return (PsiModifierListOwner)parentOwner;
    }

    private static boolean isInitializedWithSameExpression(final PsiField field, final PsiAssignmentExpression assignment, final Collection<PsiAssignmentExpression> initializingAssignments) {
        final PsiExpression expression2 = assignment.getRExpression();
        if (expression2 == null) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        final Ref result2 = new Ref((Object)Boolean.TRUE);
        final ArrayList totalUsages = new ArrayList();
        containingClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                if (!((Boolean)result2.get()).booleanValue()) {
                    return;
                }
                super.visitReferenceExpression(reference);
                if (!PsiUtil.isOnAssignmentLeftHand((PsiExpression)reference)) {
                    return;
                }
                PsiElement resolved = reference.resolve();
                if (resolved != field) {
                    return;
                }
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiAssignmentExpression.class);
                if (assignmentExpression == null) {
                    return;
                }
                PsiExpression rValue = assignmentExpression.getRExpression();
                PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)assignmentExpression, PsiMember.class);
                if (member instanceof PsiClassInitializer || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
                    if (rValue == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)rValue, (PsiElement)expression2)) {
                        result2.set((Object)Boolean.FALSE);
                    }
                    initializingAssignments.add(assignmentExpression);
                }
                totalUsages.add(assignment);
            }
        });
        if (totalUsages.size() == 1 && initializingAssignments.isEmpty()) {
            initializingAssignments.addAll(totalUsages);
            return true;
        }
        return (Boolean)result2.get();
    }

    private static PsiField getAssignedField(PsiAssignmentExpression assignment) {
        PsiExpression lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpression).resolve();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        return (PsiField)resolved;
    }

    private static class MoveFieldAssignmentToInitializerFix
    implements LocalQuickFix {
        private MoveFieldAssignmentToInitializerFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CodeInsightBundle.message((String)"intention.move.field.assignment.to.declaration", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/MoveFieldAssignmentToInitializerInspection$MoveFieldAssignmentToInitializerFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiCodeBlock body2;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/MoveFieldAssignmentToInitializerInspection$MoveFieldAssignmentToInitializerFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/MoveFieldAssignmentToInitializerInspection$MoveFieldAssignmentToInitializerFix", "applyFix"));
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiAssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            PsiField field = MoveFieldAssignmentToInitializerInspection.getAssignedField(assignment);
            if (field == null) {
                return;
            }
            ArrayList assignments = new ArrayList();
            if (!MoveFieldAssignmentToInitializerInspection.isInitializedWithSameExpression(field, assignment, assignments)) {
                return;
            }
            PsiElement prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)assignment.getParent(), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
            String comments = prev == null ? null : CommentTracker.commentsBetween(prev, (PsiElement)assignment);
            PsiExpression initializer = assignment.getRExpression();
            field.setInitializer(initializer);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            if (comments != null) {
                PsiCodeBlock block = factory.createCodeBlockFromText("{" + comments + "}", (PsiElement)initializer);
                for (PsiElement child : block.getChildren()) {
                    if (!(child instanceof PsiComment) && !(child instanceof PsiWhiteSpace)) continue;
                    field.getParent().addBefore(child, (PsiElement)field);
                }
            }
            PsiModifierListOwner owner2 = MoveFieldAssignmentToInitializerInspection.enclosingMethodOrClassInitializer(assignment, field);
            for (PsiAssignmentExpression assignmentExpression : assignments) {
                PsiElement statement2 = assignmentExpression.getParent();
                PsiElement parent = statement2.getParent();
                if (parent instanceof PsiIfStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiForeachStatement) {
                    PsiStatement emptyStatement = factory.createStatementFromText(";", statement2);
                    statement2.replace((PsiElement)emptyStatement);
                    continue;
                }
                statement2.delete();
            }
            if (owner2 instanceof PsiClassInitializer && (body2 = ((PsiClassInitializer)owner2).getBody()).getStatements().length == 0) {
                if (Arrays.stream(body2.getChildren()).noneMatch(PsiComment.class::isInstance)) {
                    owner2.delete();
                }
            }
        }
    }
}

