/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalAssignedToNullInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/OptionalAssignedToNullInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkNulls(expression2.getType(), expression2.getRExpression(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.assignment", (Object[])new Object[0]));
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length > args.length) {
                    return;
                }
                boolean varArgCall = MethodCallUtils.isVarArgCall(call);
                if (!varArgCall && parameters2.length < args.length) {
                    return;
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    PsiParameter parameter = parameters2[Math.min(parameters2.length - 1, i2)];
                    PsiType type2 = parameter.getType();
                    if (varArgCall && i2 >= parameters2.length - 1 && type2 instanceof PsiEllipsisType) {
                        type2 = ((PsiEllipsisType)type2).getComponentType();
                    }
                    this.checkNulls(type2, args[i2], InspectionsBundle.message((String)"inspection.null.value.for.optional.context.parameter", (Object[])new Object[0]));
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiElement body2 = lambda2.getBody();
                if (body2 instanceof PsiExpression) {
                    this.checkNulls(LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2), (PsiExpression)body2, InspectionsBundle.message((String)"inspection.null.value.for.optional.context.lambda", (Object[])new Object[0]));
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement2) {
                this.checkNulls(PsiTypesUtil.getMethodReturnType((PsiElement)statement2), statement2.getReturnValue(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.return", (Object[])new Object[0]));
            }

            public void visitVariable(PsiVariable variable) {
                this.checkNulls(variable.getType(), variable.getInitializer(), InspectionsBundle.message((String)"inspection.null.value.for.optional.context.declaration", (Object[])new Object[0]));
            }

            private void checkNulls(PsiType type2, PsiExpression expression2, String declaration2) {
                if (expression2 != null && TypeUtils.isOptional(type2)) {
                    ExpressionUtils.nonStructuralChildren(expression2).filter(ExpressionUtils::isNullLiteral).forEach(nullLiteral -> this.register((PsiExpression)nullLiteral, (PsiClassType)type2, declaration2));
                }
            }

            private void register(PsiExpression expression2, PsiClassType type2, String contextName) {
                holder.registerProblem((PsiElement)expression2, InspectionsBundle.message((String)"inspection.null.value.for.optional.message", (Object[])new Object[]{contextName}), new LocalQuickFix[]{new ReplaceWithEmptyOptionalFix(type2)});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalAssignedToNullInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceWithEmptyOptionalFix
    implements LocalQuickFix {
        private final String myTypeName;
        private final String myTypeParameter;
        private final String myMethodName;

        public ReplaceWithEmptyOptionalFix(PsiClassType type2) {
            this.myTypeName = type2.rawType().getCanonicalText();
            PsiType[] parameters2 = type2.getParameters();
            this.myTypeParameter = parameters2.length == 1 ? "<" + GenericsUtil.getVariableTypeByExpressionType((PsiType)parameters2[0]).getCanonicalText() + ">" : "";
            this.myMethodName = this.myTypeName.equals("com.google.common.base.Optional") ? "absent" : "empty";
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.name", (Object[])new Object[]{StringUtil.getShortName((String)this.myTypeName) + "." + this.myMethodName + "()"});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.null.value.for.optional.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/OptionalAssignedToNullInspection$ReplaceWithEmptyOptionalFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiExpression)) {
                return;
            }
            String emptyCall = this.myTypeName + "." + this.myTypeParameter + this.myMethodName + "()";
            PsiElement result2 = element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(emptyCall, element));
            PsiDiamondTypeUtil.removeRedundantTypeArguments(result2);
        }
    }
}

