/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoveInitializerFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(RemoveInitializerFix.class);

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.unused.assignment.remove.quickfix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RemoveInitializerFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RemoveInitializerFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RemoveInitializerFix", "applyFix"));
        }
        PsiElement psiInitializer = descriptor.getPsiElement();
        if (!(psiInitializer instanceof PsiExpression)) {
            return;
        }
        if (!(psiInitializer.getParent() instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)psiInitializer.getParent();
        RemoveInitializerFix.sideEffectAwareRemove(project2, (PsiExpression)psiInitializer, psiInitializer, variable);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void sideEffectAwareRemove(Project project2, PsiExpression psiInitializer, PsiElement elementToDelete, PsiVariable variable) {
        RemoveUnusedVariableUtil.RemoveMode res;
        if (!FileModificationService.getInstance().prepareFileForWrite(elementToDelete.getContainingFile())) {
            return;
        }
        PsiElement declaration2 = variable.getParent();
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(psiInitializer, variable, sideEffects);
        if (hasSideEffects) {
            hasSideEffects = PsiUtil.isStatement((PsiElement)psiInitializer);
            PsiTypeElement typeElement = variable.getTypeElement();
            res = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, FileEditorManager.getInstance((Project)project2).getSelectedTextEditor(), hasSideEffects, ((PsiElement)sideEffects.get(0)).getText(), (typeElement != null ? typeElement.getText() + " " + variable.getName() + ";<br>" : "") + PsiExpressionTrimRenderer.render((PsiExpression)psiInitializer));
        } else {
            res = RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        WriteAction.run(() -> {
            if (res == RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL) {
                elementToDelete.delete();
            } else if (res == RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT) {
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
                PsiStatement statementFromText = factory.createStatementFromText(psiInitializer.getText() + ";", null);
                PsiElement parent = elementToDelete.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    parent.replace((PsiElement)statementFromText);
                } else {
                    declaration2.getParent().addBefore((PsiElement)statementFromText, declaration2);
                    elementToDelete.delete();
                }
            }
        });
    }
}

