/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.replace.ternary.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getName"));
        }
        return string;
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToAssert", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "<init>"));
        }
        this.myText = expressionToAssert.getText();
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiFile file2 = expression2.getContainingFile();
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWthConditionalExpression(project2, this.myText + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        if (elseExpression2 != null) {
            ((Navigatable)elseExpression2).navigate(true);
            SelectInEditorManager.getInstance((Project)project2).selectInEditor(file2.getVirtualFile(), elseExpression2.getTextRange().getStartOffset(), elseExpression2.getTextRange().getEndOffset(), false, true);
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWthConditionalExpression(@NotNull Project project2, @NotNull String condition2, @NotNull PsiExpression expression2, @NotNull String defaultValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (condition2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiElement parent = expression2.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition2 + " ? " + expression2.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        PsiConditionalExpression psiConditionalExpression = (PsiConditionalExpression)expression2.replace(codeStyleManager.reformat((PsiElement)conditionalExpression));
        if (psiConditionalExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        return psiConditionalExpression;
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression2) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression2.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "suggestDefaultValue"));
        }
        PsiType type2 = expression2.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }
}

