/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTrivialLambdaFix
implements LocalQuickFix {
    private final String myValue;

    public ReplaceWithTrivialLambdaFix(Object value2) {
        this.myValue = String.valueOf(value2);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.name", (Object[])new Object[]{this.myValue});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.replace.with.trivial.lambda.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceWithTrivialLambdaFix", "applyFix"));
        }
        PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiMethodReferenceExpression.class);
        if (methodRef == null) {
            return;
        }
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(methodRef, true, true);
        if (lambdaExpression == null) {
            return;
        }
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 == null) {
            return;
        }
        body2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(this.myValue, (PsiElement)lambdaExpression));
    }
}

