/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialFunctionalExpressionUsageInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression2, call -> expression2.resolve() != null);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 == null) {
                    return;
                }
                Predicate<PsiMethodCallExpression> checkBody = call -> {
                    PsiElement statementParent;
                    PsiElement callParent = call.getParent();
                    if (!(body2 instanceof PsiCodeBlock)) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || expression2.isValueCompatible();
                    }
                    Object[] statements = ((PsiCodeBlock)body2).getStatements();
                    if (statements.length == 1) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || statements[0] instanceof PsiReturnStatement && expression2.isValueCompatible();
                    }
                    PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiCodeBlock)((PsiCodeBlock)body2));
                    if (returnStatements.length > 1) {
                        return false;
                    }
                    if (returnStatements.length == 1) {
                        if (!(ArrayUtil.getLastElement((Object[])statements) instanceof PsiReturnStatement)) {
                            return false;
                        }
                        if (returnStatements[0].getReturnValue() != null && callParent instanceof PsiLocalVariable) {
                            return true;
                        }
                    }
                    if (callParent instanceof PsiExpressionStatement && (statementParent = callParent.getParent()) instanceof PsiForStatement && callParent != ((PsiForStatement)statementParent).getBody()) {
                        return false;
                    }
                    return callParent instanceof PsiStatement && !(callParent instanceof PsiLoopStatement) || callParent instanceof PsiLambdaExpression;
                };
                Predicate<PsiMethodCallExpression> checkWrites = call -> Arrays.stream(expression2.getParameterList().getParameters()).noneMatch(parameter -> VariableAccessUtils.variableIsAssigned((PsiVariable)parameter, body2));
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression2, checkBody.and(checkWrites));
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, Collections.emptySet())) {
                    PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)aClass.getParent(), PsiNewExpression.class);
                    this.doCheckMethodCallOnFunctionalExpression(call -> {
                        PsiMethod method = aClass.getMethods()[0];
                        PsiCodeBlock body2 = method.getBody();
                        PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiCodeBlock)body2);
                        if (returnStatements.length > 1) {
                            return false;
                        }
                        PsiElement callParent = call.getParent();
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable;
                    }, (PsiExpression)newExpression, (PsiType)aClass.getBaseClassType(), new ReplaceAnonymousWithLambdaBodyFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(PsiElement expression2, Predicate<PsiMethodCallExpression> elementContainerPredicate) {
                PsiTypeCastExpression parent = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent()), PsiTypeCastExpression.class);
                if (parent != null) {
                    PsiType interfaceType = parent.getType();
                    this.doCheckMethodCallOnFunctionalExpression(elementContainerPredicate, (PsiExpression)parent, interfaceType, expression2 instanceof PsiLambdaExpression ? new ReplaceWithLambdaBodyFix() : new ReplaceWithMethodReferenceFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(Predicate<PsiMethodCallExpression> elementContainerPredicate, PsiExpression qualifier, PsiType interfaceType, LocalQuickFix fix) {
                boolean suitableMethod;
                PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier(qualifier);
                if (call == null) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                PsiElement referenceNameElement = call.getMethodExpression().getReferenceNameElement();
                boolean bl = suitableMethod = method != null && referenceNameElement != null && !method.isVarArgs() && call.getArgumentList().getExpressions().length == method.getParameterList().getParametersCount() && elementContainerPredicate.test(call);
                if (!suitableMethod) {
                    return;
                }
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)interfaceType);
                if (method == interfaceMethod || interfaceMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)method)) {
                    holder.registerProblem(referenceNameElement, "Method call can be simplified", new LocalQuickFix[]{fix});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void replaceWithLambdaBody(PsiLambdaExpression lambda2) {
        if ((lambda2 = TrivialFunctionalExpressionUsageInspection.extractSideEffects(lambda2)) == null) {
            return;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
        if (callExpression == null) {
            return;
        }
        PsiElement body2 = lambda2.getBody();
        PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
        if (expression2 != null) {
            TrivialFunctionalExpressionUsageInspection.replaceExpression(callExpression, lambda2);
        } else if (body2 instanceof PsiCodeBlock) {
            TrivialFunctionalExpressionUsageInspection.replaceCodeBlock(lambda2);
        }
    }

    private static PsiLambdaExpression extractSideEffects(PsiLambdaExpression lambda2) {
        PsiParameter[] parameters2;
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
        if (callExpression == null) {
            return lambda2;
        }
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (Stream.of(arguments).noneMatch(SideEffectChecker::mayHaveSideEffects)) {
            return lambda2;
        }
        if ((lambda2 = RefactoringUtil.ensureCodeBlock(lambda2)) == null) {
            return null;
        }
        callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiMethodCallExpression.class);
        if (callExpression == null) {
            return lambda2;
        }
        arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != (parameters2 = lambda2.getParameterList().getParameters()).length) {
            return lambda2;
        }
        PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)lambda2, PsiStatement.class, (boolean)false);
        if (anchor == null) {
            return lambda2;
        }
        ArrayList<PsiStatement> statements = new ArrayList<PsiStatement>();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)lambda2.getProject());
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            PsiExpression argument = arguments[i2];
            PsiParameter parameter = parameters2[i2];
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(argument);
            if (sideEffects.isEmpty()) continue;
            boolean used = VariableAccessUtils.variableIsUsed((PsiVariable)parameter, lambda2.getBody());
            if (used) {
                String name2 = parameter.getName();
                if (name2 == null) continue;
                statements.add(factory.createStatementFromText(parameter.getType().getCanonicalText() + " " + name2 + "=" + argument.getText() + ";", (PsiElement)lambda2));
                argument.replace((PsiElement)factory.createExpressionFromText(name2, (PsiElement)parameter));
                continue;
            }
            Collections.addAll(statements, StatementExtractor.generateStatements(sideEffects, argument));
        }
        BlockUtils.addBefore(anchor, statements.toArray(PsiStatement.EMPTY_ARRAY));
        return lambda2;
    }

    private static void replaceExpression(PsiMethodCallExpression callExpression, PsiLambdaExpression element) {
        CommentTracker ct = new CommentTracker();
        TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
        PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)element.getBody());
        ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(expression2));
    }

    private static void replaceCodeBlock(PsiLambdaExpression element) {
        PsiExpression returnValue;
        if ((element = RefactoringUtil.ensureCodeBlock(element)) == null) {
            return;
        }
        PsiElement body2 = element.getBody();
        if (!(body2 instanceof PsiCodeBlock)) {
            return;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (callExpression == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
        body2 = element.getBody();
        PsiElement parent = callExpression.getParent();
        PsiStatement[] statements = ((PsiCodeBlock)body2).getStatements();
        if (statements.length == 0) {
            return;
        }
        PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class, (boolean)false);
        PsiReturnStatement statement2 = (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[statements.length - 1], PsiReturnStatement.class);
        if (anchor != null) {
            PsiElement gParent = anchor.getParent();
            for (PsiElement child : body2.getChildren()) {
                if (child == statement2 || child instanceof PsiJavaToken) continue;
                gParent.addBefore(ct.markUnchanged(child), (PsiElement)anchor);
            }
        }
        PsiExpression psiExpression = returnValue = statement2 == null ? null : statement2.getReturnValue();
        if (returnValue != null) {
            ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(returnValue));
        } else {
            ct.deleteAndRestoreComments((PsiElement)callExpression);
        }
    }

    private static void inlineCallArguments(PsiMethodCallExpression callExpression, PsiLambdaExpression element, CommentTracker ct) {
        PsiExpression[] args = callExpression.getArgumentList().getExpressions();
        PsiParameter[] parameters2 = element.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            PsiExpression initializer = args[i2];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                ct.markUnchanged(initializer);
                InlineUtil.inlineVariable((PsiVariable)parameter, initializer, (PsiJavaCodeReferenceElement)referenceElement);
            }
        }
    }

    private static abstract class ReplaceFix
    implements LocalQuickFix {
        private ReplaceFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethodCallExpression.class);
            if (callExpression != null) {
                this.fixExpression(callExpression, PsiUtil.skipParenthesizedExprDown((PsiExpression)callExpression.getMethodExpression().getQualifierExpression()));
            }
        }

        protected abstract void fixExpression(PsiMethodCallExpression var1, PsiExpression var2);
    }

    private static class ReplaceAnonymousWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceAnonymousWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace call with method body" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceAnonymousWithLambdaBodyFix", "getFamilyName"));
            }
            return "Replace call with method body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiExpression lambdaExpression;
            PsiExpression cast = AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)qualifierExpression2, true, false);
            if (cast instanceof PsiTypeCastExpression && (lambdaExpression = ((PsiTypeCastExpression)cast).getOperand()) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody((PsiLambdaExpression)lambdaExpression);
            }
        }
    }

    private static class ReplaceWithMethodReferenceFix
    extends ReplaceFix {
        private ReplaceWithMethodReferenceFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace method call on method reference with corresponding method call" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceWithMethodReferenceFix", "getFamilyName"));
            }
            return "Replace method call on method reference with corresponding method call";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiLambdaExpression lambdaExpression;
            PsiExpression element;
            if (qualifierExpression2 instanceof PsiTypeCastExpression && (element = ((PsiTypeCastExpression)qualifierExpression2).getOperand()) instanceof PsiMethodReferenceExpression && (lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)element, false, true)) != null) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(lambdaExpression);
            }
        }
    }

    private static class ReplaceWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace method call on lambda with lambda body" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/TrivialFunctionalExpressionUsageInspection$ReplaceWithLambdaBodyFix", "getFamilyName"));
            }
            return "Replace method call on lambda with lambda body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiExpression element;
            if (qualifierExpression2 instanceof PsiTypeCastExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiTypeCastExpression)qualifierExpression2).getOperand())) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody((PsiLambdaExpression)element);
            }
        }
    }
}

