/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseCompareMethodInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/UseCompareMethodInspection", "buildVisitor"));
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_1_4)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/UseCompareMethodInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                CompareInfo info = UseCompareMethodInspection.fromCall(call);
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (info != null && nameElement != null) {
                    this.register(info, nameElement);
                }
            }

            public void visitIfStatement(PsiIfStatement statement2) {
                CompareInfo info = UseCompareMethodInspection.fromIf(statement2);
                PsiElement keyword = statement2.getFirstChild();
                if (info != null && keyword != null) {
                    this.register(info, keyword);
                }
            }

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                CompareInfo info = UseCompareMethodInspection.fromTernary(expression2);
                if (info != null) {
                    this.register(info, (PsiElement)expression2);
                }
            }

            private void register(CompareInfo info, PsiElement nameElement) {
                holder.registerProblem(nameElement, "Can be replaced with '" + info.myClass.getClassName() + ".compare'", new LocalQuickFix[]{new ReplaceWithPrimitiveCompareFix(info.myClass.getCanonicalText())});
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/UseCompareMethodInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static CompareInfo fromIf(PsiIfStatement ifStatement) {
        PsiExpression firstCondition = ifStatement.getCondition();
        if (firstCondition == null) {
            return null;
        }
        PsiIfStatement elseIfStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)UseCompareMethodInspection.getElse(ifStatement), PsiIfStatement.class);
        if (elseIfStatement == null) {
            return null;
        }
        PsiExpression secondCondition = elseIfStatement.getCondition();
        if (secondCondition == null) {
            return null;
        }
        PsiStatement firstStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (firstStatement == null) {
            return null;
        }
        PsiStatement secondStatement = ControlFlowUtils.stripBraces(elseIfStatement.getThenBranch());
        if (secondStatement == null) {
            return null;
        }
        PsiStatement thirdStatement = UseCompareMethodInspection.getElse(elseIfStatement);
        if (thirdStatement == null) {
            return null;
        }
        HashMap<Integer, PsiExpression> result2 = new HashMap<Integer, PsiExpression>(3);
        if (firstStatement instanceof PsiReturnStatement) {
            if (!(secondStatement instanceof PsiReturnStatement) || !(thirdStatement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiExpression firstValue = ((PsiReturnStatement)firstStatement).getReturnValue();
            if (!UseCompareMethodInspection.storeCondition(result2, firstCondition, firstValue)) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result2, secondCondition, ((PsiReturnStatement)secondStatement).getReturnValue())) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result2, null, ((PsiReturnStatement)thirdStatement).getReturnValue())) {
                return null;
            }
            return UseCompareMethodInspection.fromMap(result2, firstValue, (PsiElement)firstStatement);
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)firstStatement);
        if (assignment == null) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        PsiExpression firstExpression = assignment.getRExpression();
        if (!UseCompareMethodInspection.storeCondition(result2, firstCondition, firstExpression)) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result2, secondCondition, ExpressionUtils.getAssignmentTo((PsiElement)secondStatement, variable))) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result2, null, ExpressionUtils.getAssignmentTo((PsiElement)thirdStatement, variable))) {
            return null;
        }
        return UseCompareMethodInspection.fromMap(result2, firstExpression, (PsiElement)assignment);
    }

    private static PsiStatement getElse(PsiIfStatement ifStatement) {
        PsiStatement branch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (branch != null) {
            return branch;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiReturnStatement)) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)ifStatement, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
        return (PsiStatement)ObjectUtils.tryCast((Object)next, PsiStatement.class);
    }

    @Nullable
    private static Map<Integer, PsiExpression> extractConditions(PsiConditionalExpression ternary) {
        HashMap<Integer, PsiExpression> result2 = new HashMap<Integer, PsiExpression>(3);
        if (!UseCompareMethodInspection.storeCondition(result2, ternary.getCondition(), ternary.getThenExpression())) {
            return null;
        }
        PsiExpression elseExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getElseExpression());
        if (elseExpression2 instanceof PsiConditionalExpression) {
            Map<Integer, PsiExpression> m = UseCompareMethodInspection.extractConditions((PsiConditionalExpression)elseExpression2);
            if (m == null) {
                return null;
            }
            result2.putAll(m);
            return result2;
        }
        return UseCompareMethodInspection.storeCondition(result2, null, elseExpression2) ? result2 : null;
    }

    @Contract(value="_, _, null -> false")
    private static boolean storeCondition(@NotNull Map<Integer, PsiExpression> result2, @Nullable PsiExpression condition2, @Nullable PsiExpression expression2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/UseCompareMethodInspection", "storeCondition"));
        }
        if (expression2 == null) {
            return false;
        }
        Object thenValue = ExpressionUtils.computeConstantExpression(expression2);
        if (!(thenValue instanceof Integer) || Math.abs((Integer)thenValue) > 1) {
            return false;
        }
        result2.put((Integer)thenValue, condition2);
        return true;
    }

    private static CompareInfo fromTernary(PsiConditionalExpression ternary) {
        if (!PsiType.INT.equals((Object)ternary.getType())) {
            return null;
        }
        Map<Integer, PsiExpression> map2 = UseCompareMethodInspection.extractConditions(ternary);
        return UseCompareMethodInspection.fromMap(map2, (PsiExpression)ternary, (PsiElement)ternary);
    }

    private static CompareInfo fromMap(@Nullable Map<Integer, PsiExpression> map2, @NotNull PsiExpression expression2, @NotNull PsiElement template) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/UseCompareMethodInspection", "fromMap"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInspection/UseCompareMethodInspection", "fromMap"));
        }
        if (map2 == null || map2.size() != 3) {
            return null;
        }
        PsiExpression lt = map2.get(-1);
        Pair<PsiExpression, PsiExpression> ltPair = UseCompareMethodInspection.getOperands(lt, JavaTokenType.LT);
        if (lt != null && ltPair == null) {
            return null;
        }
        PsiExpression gt = map2.get(1);
        Pair<PsiExpression, PsiExpression> gtPair = UseCompareMethodInspection.getOperands(gt, JavaTokenType.GT);
        if ((gt != null || ltPair == null) && gtPair == null) {
            return null;
        }
        if (ltPair != null && gtPair != null) {
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)ltPair.getFirst()), (PsiElement)((PsiElement)gtPair.getFirst()))) {
                return null;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)ltPair.getSecond()), (PsiElement)((PsiElement)gtPair.getSecond()))) {
                return null;
            }
        }
        Pair<PsiExpression, PsiExpression> canonicalPair = ltPair == null ? gtPair : ltPair;
        PsiType leftType = ((PsiExpression)canonicalPair.getFirst()).getType();
        PsiType rightType = ((PsiExpression)canonicalPair.getSecond()).getType();
        if (!UseCompareMethodInspection.isTypeConvertible(leftType, (PsiElement)expression2) || !leftType.equals(rightType)) {
            return null;
        }
        PsiExpression eq = map2.get(0);
        Pair<PsiExpression, PsiExpression> eqPair = UseCompareMethodInspection.getOperands(eq, JavaTokenType.EQEQ);
        if (eq != null && eqPair == null) {
            return null;
        }
        if (!(eqPair == null || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getFirst()), (PsiElement)((PsiElement)eqPair.getFirst())) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getSecond()), (PsiElement)((PsiElement)eqPair.getSecond())) || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getFirst()), (PsiElement)((PsiElement)eqPair.getSecond())) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getSecond()), (PsiElement)((PsiElement)eqPair.getFirst())))) {
            return null;
        }
        PsiClassType boxedType = ((PsiPrimitiveType)leftType).getBoxedType((PsiElement)expression2);
        if (boxedType == null) {
            return null;
        }
        return new CompareInfo(template, expression2, (PsiExpression)canonicalPair.getFirst(), (PsiExpression)canonicalPair.getSecond(), boxedType);
    }

    private static Pair<PsiExpression, PsiExpression> getOperands(PsiExpression expression2, IElementType expectedToken) {
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)expression2;
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        if (binOp.getOperationTokenType().equals(expectedToken)) {
            return Pair.create((Object)left, (Object)right);
        }
        if (expectedToken.equals(JavaTokenType.GT) && binOp.getOperationTokenType().equals(JavaTokenType.LT) || expectedToken.equals(JavaTokenType.LT) && binOp.getOperationTokenType().equals(JavaTokenType.GT)) {
            return Pair.create((Object)right, (Object)left);
        }
        return null;
    }

    @Nullable
    static PsiClassType getBoxedType(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)call.getProject()).createType(aClass);
    }

    @Nullable
    static PsiExpression extractPrimitive(PsiClassType type2, PsiPrimitiveType primitiveType, PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return null;
        }
        if (primitiveType.equals((Object)expression2.getType())) {
            return expression2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (!"valueOf".equals(call.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null || type2.resolve() != method.getContainingClass()) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression2;
            if (!type2.equals((Object)cast.getType())) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(cast.getOperand());
        }
        if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            if (!type2.equals((Object)newExpression.getType())) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            if (!(args[0].getType() instanceof PsiPrimitiveType)) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        return null;
    }

    private static PsiExpression checkPrimitive(PsiExpression expression2) {
        return expression2 != null && expression2.getType() instanceof PsiPrimitiveType ? expression2 : null;
    }

    @Contract(value="null -> null")
    private static CompareInfo fromCall(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
        if (nameElement == null) {
            return null;
        }
        String name2 = nameElement.getText();
        if (!"compareTo".equals(name2)) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClassType boxedType = UseCompareMethodInspection.getBoxedType(call);
        if (boxedType == null) {
            return null;
        }
        PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
        if (!UseCompareMethodInspection.isTypeConvertible((PsiType)primitiveType, (PsiElement)call)) {
            return null;
        }
        PsiExpression left = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, qualifier);
        if (left == null) {
            return null;
        }
        PsiExpression right = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, arg);
        if (right == null) {
            return null;
        }
        return new CompareInfo((PsiElement)call, (PsiExpression)call, left, right, boxedType);
    }

    @Contract(value="null, _ -> false")
    private static boolean isTypeConvertible(PsiType type2, PsiElement context) {
        return type2 instanceof PsiPrimitiveType && (PsiType.DOUBLE.equals((Object)type2) || PsiType.FLOAT.equals((Object)type2) || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context));
    }

    private static class ReplaceWithPrimitiveCompareFix
    implements LocalQuickFix {
        private String myClassName;

        public ReplaceWithPrimitiveCompareFix(String className) {
            this.myClassName = className;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with '" + StringUtil.getShortName((String)this.myClassName) + ".compare'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix", "getName"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with static 'compare' method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix", "getFamilyName"));
            }
            return "Replace with static 'compare' method";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            CompareInfo info;
            PsiElement toReplace;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            ArrayList<PsiStatement> toDelete = new ArrayList<PsiStatement>();
            if (element instanceof PsiConditionalExpression) {
                toReplace = element;
                info = UseCompareMethodInspection.fromTernary((PsiConditionalExpression)element);
            } else {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement) {
                    toReplace = parent;
                    info = UseCompareMethodInspection.fromIf((PsiIfStatement)parent);
                    PsiStatement elseIf = UseCompareMethodInspection.getElse((PsiIfStatement)parent);
                    toDelete.add(elseIf);
                    if (elseIf instanceof PsiIfStatement) {
                        toDelete.add(UseCompareMethodInspection.getElse((PsiIfStatement)elseIf));
                    }
                } else {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                    info = UseCompareMethodInspection.fromCall(call);
                    toReplace = call;
                }
            }
            if (info == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            info.replace(toReplace, ct);
            ((StreamEx)((StreamEx)StreamEx.of(toDelete).nonNull()).filter(PsiElement::isValid)).forEach(e -> new CommentTracker().deleteAndRestoreComments((PsiElement)e));
        }
    }

    static class CompareInfo {
        @NotNull
        final PsiElement myTemplate;
        @NotNull
        final PsiExpression myToReplace;
        @NotNull
        final PsiExpression myLeft;
        @NotNull
        final PsiExpression myRight;
        @NotNull
        final PsiClassType myClass;

        CompareInfo(@NotNull PsiElement template, @NotNull PsiExpression toReplace, @NotNull PsiExpression left, @NotNull PsiExpression right, @NotNull PsiClassType aClass) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo", "<init>"));
            }
            if (toReplace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReplace", "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo", "<init>"));
            }
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo", "<init>"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo", "<init>"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo", "<init>"));
            }
            this.myTemplate = template;
            this.myToReplace = toReplace;
            this.myLeft = left;
            this.myRight = right;
            this.myClass = aClass;
        }

        private void replace(PsiElement toReplace, CommentTracker ct) {
            String replacement = this.myClass.getCanonicalText() + ".compare(" + ct.text((PsiElement)this.myLeft) + "," + ct.text((PsiElement)this.myRight) + ")";
            if (toReplace == this.myTemplate) {
                ct.replaceAndRestoreComments((PsiElement)this.myToReplace, replacement);
            } else {
                ct.replace((PsiElement)this.myToReplace, replacement);
                ct.replaceAndRestoreComments(toReplace, this.myTemplate);
            }
        }
    }
}

