/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CleanupInspectionIntention.class);
    private final InspectionToolWrapper myToolWrapper;
    private final Class myQuickfixClass;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull Class quickFixClass, String text2) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "<init>"));
        }
        if (quickFixClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixClass", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "<init>"));
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfixClass = quickFixClass;
        this.myText = text2;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "invoke"));
        }
        List descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "lambda$invoke$0"));
            }
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project2);
            return InspectionEngine.runInspectionOnFile(file2, this.myToolWrapper, inspectionManager.createNewGlobalContext(false));
        }, (ProgressIndicator)new EmptyProgressIndicator());
        if (!descriptions.isEmpty() && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionIntention.applyFixes(project2, "Apply Fixes", descriptions, this.myQuickfixClass);
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, "Unfortunately '" + this.myText + "' is currently not available for batch mode\n User interaction is required for each problem found");
        }
    }

    public static AbstractPerformFixesTask applyFixes(@NotNull Project project2, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixes"));
        }
        if (presentationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationText", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixes"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixes"));
        }
        CleanupInspectionIntention.sortDescriptions(descriptions);
        return CleanupInspectionIntention.applyFixesNoSort(project2, presentationText, descriptions, quickfixClass);
    }

    public static AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project2, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixesNoSort"));
        }
        if (presentationText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationText", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixesNoSort"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "applyFixesNoSort"));
        }
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, presentationText, true);
        boolean isBatch = quickfixClass != null && BatchQuickFix.class.isAssignableFrom(quickfixClass);
        AbstractPerformFixesTask fixesTask = isBatch ? new PerformBatchFixesTask(project2, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), progressTask, quickfixClass) : new PerformFixesTask(project2, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), progressTask, quickfixClass);
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "lambda$applyFixesNoSort$1"));
            }
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            progressTask.setMinIterationTime(200L);
            progressTask.setTask(fixesTask);
            ProgressManager.getInstance().run((Task)progressTask);
        }, presentationText, null);
        return fixesTask;
    }

    public static void sortDescriptions(@NotNull List<ProblemDescriptor> descriptions) {
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "sortDescriptions"));
        }
        Collections.sort(descriptions, CommonProblemDescriptor.DESCRIPTOR_COMPARATOR);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "isAvailable"));
        }
        return this.myQuickfixClass != EmptyIntentionAction.class && editor != null && (!(this.myToolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class PerformFixesTask
    extends AbstractPerformFixesTask {
        public PerformFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @Nullable Class quickFixClass) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            super(project2, descriptors, task, quickFixClass);
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor, Project project2) {
            fix.applyFix(project2, (CommonProblemDescriptor)descriptor);
        }
    }

    private static class PerformBatchFixesTask
    extends AbstractPerformFixesTask {
        private final List<ProblemDescriptor> myBatchModeDescriptors;
        private boolean myApplied;

        public PerformBatchFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @NotNull Class quickfixClass) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformBatchFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformBatchFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformBatchFixesTask", "<init>"));
            }
            if (quickfixClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickfixClass", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformBatchFixesTask", "<init>"));
            }
            super(project2, descriptors, task, quickfixClass);
            this.myBatchModeDescriptors = new ArrayList<ProblemDescriptor>();
            this.myApplied = false;
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor, Project project2) {
            this.myBatchModeDescriptors.add(descriptor);
        }

        @Override
        public boolean isDone() {
            if (super.isDone()) {
                if (!this.myApplied && !this.myBatchModeDescriptors.isEmpty()) {
                    ProblemDescriptor representative = this.myBatchModeDescriptors.get(0);
                    LOG.assertTrue(representative.getFixes() != null);
                    for (QuickFix fix : representative.getFixes()) {
                        if (fix == null || !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                        ((BatchQuickFix)fix).applyFix(this.myProject, (CommonProblemDescriptor[])this.myBatchModeDescriptors.toArray(new ProblemDescriptor[this.myBatchModeDescriptors.size()]), new ArrayList(), null);
                        break;
                    }
                    this.myApplied = true;
                }
                return true;
            }
            return false;
        }
    }

    private static abstract class AbstractPerformFixesTask
    extends PerformFixesModalTask {
        private boolean myApplicableFixFound;
        protected final Class myQuickfixClass;

        public AbstractPerformFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @Nullable Class quickfixClass) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention$AbstractPerformFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/actions/CleanupInspectionIntention$AbstractPerformFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/actions/CleanupInspectionIntention$AbstractPerformFixesTask", "<init>"));
            }
            super(project2, descriptors, task);
            this.myApplicableFixFound = false;
            this.myQuickfixClass = quickfixClass;
        }

        protected abstract void collectFix(QuickFix var1, ProblemDescriptor var2, Project var3);

        @Override
        protected final void applyFix(Project project2, CommonProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            if (fixes != null && fixes.length > 0) {
                for (QuickFix fix : fixes) {
                    if (fix == null || this.myQuickfixClass != null && !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                    ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
                    PsiElement element = problemDescriptor.getPsiElement();
                    if (element == null || !element.isValid()) break;
                    this.collectFix(fix, problemDescriptor, project2);
                    this.myApplicableFixFound = true;
                    break;
                }
            }
        }

        public final boolean isApplicableFixFound() {
            return this.myApplicableFixFound;
        }
    }
}

