/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.CoreHKey;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.ResultUtil;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

final class Solver {
    private final ELattice<Value> lattice;
    private final HashMap<EKey, HashSet<EKey>> dependencies = new HashMap();
    private final HashMap<EKey, Pending> pending = new HashMap();
    private final HashMap<EKey, Value> solved = new HashMap();
    private final Stack<EKey> moving = new Stack();
    private final ResultUtil resultUtil;
    private final HashMap<CoreHKey, Equation> equations = new HashMap();
    private final Value unstableValue;

    Solver(ELattice<Value> lattice, Value unstableValue) {
        this.lattice = lattice;
        this.unstableValue = unstableValue;
        this.resultUtil = new ResultUtil(lattice);
    }

    Result getUnknownResult() {
        return new Final(this.unstableValue);
    }

    void addEquation(Equation equation) {
        EKey key2 = equation.key;
        CoreHKey coreKey = new CoreHKey(key2.method, key2.dirKey);
        Equation previousEquation = this.equations.get(coreKey);
        if (previousEquation == null) {
            this.equations.put(coreKey, equation);
        } else {
            EKey joinKey = new EKey(coreKey.myMethod, coreKey.dirKey, equation.key.stable && previousEquation.key.stable, false);
            Result joinResult = this.resultUtil.join(equation.result, previousEquation.result);
            Equation joinEquation = new Equation(joinKey, joinResult);
            this.equations.put(coreKey, joinEquation);
        }
    }

    void queueEquation(Equation equation) {
        Result rhs = equation.result;
        if (rhs instanceof Final) {
            this.solved.put(equation.key, ((Final)rhs).value);
            this.moving.push(equation.key);
        } else if (rhs instanceof Pending) {
            Pending pendResult = ((Pending)rhs).copy();
            Result norm = this.normalize(pendResult.delta);
            if (norm instanceof Final) {
                this.solved.put(equation.key, ((Final)norm).value);
                this.moving.push(equation.key);
            } else {
                Pending pendResult1 = ((Pending)rhs).copy();
                for (Component component : pendResult1.delta) {
                    for (EKey trigger : component.ids) {
                        HashSet<EKey> set2 = this.dependencies.get(trigger);
                        if (set2 == null) {
                            set2 = new HashSet();
                            this.dependencies.put(trigger, set2);
                        }
                        set2.add(equation.key);
                    }
                }
                this.pending.put(equation.key, pendResult1);
            }
        }
    }

    Value negate(Value value2) {
        switch (value2) {
            case True: {
                return Value.False;
            }
            case False: {
                return Value.True;
            }
        }
        return value2;
    }

    Map<EKey, Value> solve() {
        for (Equation equation : this.equations.values()) {
            this.queueEquation(equation);
        }
        while (!this.moving.empty()) {
            Value[] valueArray;
            EKey[] eKeyArray;
            EKey id = this.moving.pop();
            Value value2 = this.solved.get(id);
            if (id.stable) {
                EKey[] eKeyArray2 = new EKey[2];
                eKeyArray2[0] = id;
                eKeyArray = eKeyArray2;
                eKeyArray2[1] = id.invertStability();
            } else {
                EKey[] eKeyArray3 = new EKey[2];
                eKeyArray3[0] = id.invertStability();
                eKeyArray = eKeyArray3;
                eKeyArray3[1] = id;
            }
            EKey[] initialPIds = eKeyArray;
            if (id.stable) {
                Value[] valueArray2 = new Value[2];
                valueArray2[0] = value2;
                valueArray = valueArray2;
                valueArray2[1] = value2;
            } else {
                Value[] valueArray3 = new Value[2];
                valueArray3[0] = value2;
                valueArray = valueArray3;
                valueArray3[1] = this.unstableValue;
            }
            Value[] initialPVals = valueArray;
            EKey[] pIds = new EKey[]{initialPIds[0], initialPIds[1], initialPIds[0].negate(), initialPIds[1].negate()};
            Value[] pVals = new Value[]{initialPVals[0], initialPVals[1], this.negate(initialPVals[0]), this.negate(initialPVals[1])};
            for (int i2 = 0; i2 < pIds.length; ++i2) {
                EKey pId = pIds[i2];
                Value pVal = pVals[i2];
                HashSet<EKey> dIds = this.dependencies.get(pId);
                if (dIds == null) continue;
                for (EKey dId : dIds) {
                    Pending pend = this.pending.remove(dId);
                    if (pend == null) continue;
                    Result pend1 = this.substitute(pend, pId, pVal);
                    if (pend1 instanceof Final) {
                        Final fi = (Final)pend1;
                        this.solved.put(dId, fi.value);
                        this.moving.push(dId);
                        continue;
                    }
                    this.pending.put(dId, (Pending)pend1);
                }
            }
        }
        this.pending.clear();
        return this.solved;
    }

    Result substitute(@NotNull Pending pending, @NotNull EKey id, @NotNull Value value2) {
        Component[] sum;
        if (pending == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pending", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "substitute"));
        }
        for (Component intIdComponent : sum = pending.delta) {
            if (!intIdComponent.remove(id)) continue;
            intIdComponent.value = this.lattice.meet(intIdComponent.value, value2);
        }
        return this.normalize(sum);
    }

    @NotNull
    Result normalize(@NotNull Component[] sum) {
        if (sum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sum", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "normalize"));
        }
        Value acc = (Value)((Object)this.lattice.bot);
        boolean computableNow = true;
        for (Component prod : sum) {
            if (prod.isEmpty() || prod.value == this.lattice.bot) {
                acc = this.lattice.join(acc, prod.value);
                continue;
            }
            computableNow = false;
        }
        Result result2 = acc == this.lattice.top || computableNow ? new Final(acc) : new Pending(sum);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/Solver", "normalize"));
        }
        return result2;
    }
}

