/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class LiteAnalyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private Frame<V>[] frames;
    private boolean[] queued;
    private int[] queue;
    private int top;

    public LiteAnalyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner2, MethodNode m) throws AnalyzerException {
        if ((m.access & 0x500) != 0 || m.instructions.size() == 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        int n = m.instructions.size();
        InsnList insns = m.instructions;
        List[] handlers = new List[n];
        this.frames = new Frame[n];
        this.queued = new boolean[n];
        this.queue = new int[n];
        this.top = 0;
        for (int i2 = 0; i2 < m.tryCatchBlocks.size(); ++i2) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i2);
            int begin = insns.indexOf((AbstractInsnNode)tcb.start);
            int end = insns.indexOf((AbstractInsnNode)tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = handlers[j];
                if (insnHandlers == null) {
                    handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Frame current = new Frame(m.maxLocals, m.maxStack);
        Frame handler2 = new Frame(m.maxLocals, m.maxStack);
        current.setReturn(this.interpreter.newValue(Type.getReturnType((String)m.desc)));
        Type[] args = Type.getArgumentTypes((String)m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType((String)owner2);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (int i3 = 0; i3 < args.length; ++i3) {
            current.setLocal(local++, this.interpreter.newValue(args[i3]));
            if (args[i3].getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.merge(0, current);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, f);
                } else {
                    int j;
                    int jump;
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current);
                        }
                        jump = insns.indexOf((AbstractInsnNode)j2.label);
                        this.merge(jump, current);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        jump = insns.indexOf((AbstractInsnNode)lsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)lsi.labels.get(j);
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        jump = insns.indexOf((AbstractInsnNode)tsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            LabelNode label = (LabelNode)tsi.labels.get(j);
                            jump = insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, current);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.merge(insn + 1, current);
                    }
                }
                if ((insnHandlers = handlers[insn]) == null) continue;
                for (int i4 = 0; i4 < insnHandlers.size(); ++i4) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)insnHandlers.get(i4);
                    int jump = insns.indexOf((AbstractInsnNode)tcb.handler);
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(this.interpreter.newValue(ASMUtils.THROWABLE_TYPE));
                    this.merge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return this.frames;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    private void merge(int insn, Frame<V> frame) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame == null) {
            this.frames[insn] = new Frame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

