/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownGuardInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unknown @GuardedBy field" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getDisplayName"));
        }
        return "Unknown @GuardedBy field";
    }

    @NotNull
    public String getShortName() {
        if ("UnknownGuard" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "getShortName"));
        }
        return "UnknownGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)annotation)) {
                return;
            }
            PsiAnnotationMemberValue member = annotation.findAttributeValue("value");
            if (member == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, "Unknown @GuardedBy reference #ref #loc", new LocalQuickFix[0]);
        }

        private static boolean isValidGuardText(@Nullable String guardText, @NotNull PsiElement context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection$Visitor", "isValidGuardText"));
            }
            if (guardText == null || "itself".equals(guardText)) {
                return false;
            }
            try {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
                PsiExpression expression2 = facade.getElementFactory().createExpressionFromText(guardText, context);
                return Visitor.isValidGuard(expression2, context);
            }
            catch (IncorrectOperationException ignore) {
                return false;
            }
        }

        private static boolean isValidGuard(PsiExpression expression2, PsiElement context) {
            if (expression2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
                JavaResolveResult result2 = referenceExpression.advancedResolve(false);
                if (!result2.isAccessible() || !result2.isValidResult()) {
                    return false;
                }
                PsiElement target2 = result2.getElement();
                PsiElement parent = expression2.getParent();
                if (!(parent instanceof DummyHolder)) {
                    return target2 != null;
                }
                if (!(target2 instanceof PsiField)) {
                    return false;
                }
                PsiField field = (PsiField)target2;
                PsiType type2 = field.getType();
                if (type2 instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                return qualifier == null || Visitor.isValidGuard(qualifier, context);
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                if (argumentList.getExpressions().length != 0) {
                    return false;
                }
                JavaResolveResult result3 = methodCallExpression.resolveMethodGenerics();
                if (!result3.isAccessible() || !result3.isValidResult()) {
                    return false;
                }
                PsiElement element = result3.getElement();
                if (!(element instanceof PsiMethod)) {
                    return false;
                }
                PsiMethod method = (PsiMethod)element;
                PsiType type3 = method.getReturnType();
                if (type3 instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                return qualifierExpression2 == null || Visitor.isValidGuard(qualifierExpression2, context);
            }
            if (expression2 instanceof PsiThisExpression) {
                PsiThisExpression thisExpression = (PsiThisExpression)expression2;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier == null) {
                    return true;
                }
                JavaResolveResult result4 = qualifier.advancedResolve(false);
                if (!result4.isValidResult() || !result4.isAccessible()) {
                    return false;
                }
                PsiElement target3 = result4.getElement();
                if (!(target3 instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target3;
                return InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)context, (boolean)false, (boolean)false);
            }
            if (expression2 instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression2;
                PsiTypeElement operand2 = classObjectAccessExpression.getOperand();
                PsiType type4 = operand2.getType();
                if (!(type4 instanceof PsiClassType)) {
                    return false;
                }
                PsiClassType classType = (PsiClassType)type4;
                PsiClass target4 = classType.resolve();
                return target4 != null;
            }
            return false;
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)psiDocTag)) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Unknown @GuardedBy reference \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }
    }
}

