/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DelegationContract;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.KnownContract;
import com.intellij.codeInspection.dataFlow.MethodCallContract;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.SideEffectFilter;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContractInferenceInterpreter {
    private final LighterAST myTree;
    private final LighterASTNode myMethod;
    private final LighterASTNode myBody;

    public ContractInferenceInterpreter(LighterAST tree, LighterASTNode method, LighterASTNode body2) {
        this.myTree = tree;
        this.myMethod = method;
        this.myBody = body2;
    }

    @NotNull
    private List<LighterASTNode> getParameters() {
        LighterASTNode paramList = LightTreeUtil.firstChildOfType(this.myTree, this.myMethod, JavaElementType.PARAMETER_LIST);
        List<LighterASTNode> list2 = paramList != null ? LightTreeUtil.getChildrenOfType(this.myTree, paramList, JavaElementType.PARAMETER) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getParameters"));
        }
        return list2;
    }

    @NotNull
    List<PreContract> inferContracts(List<LighterASTNode> statements) {
        List<PreContract> result2;
        if (statements.isEmpty()) {
            List<PreContract> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
            }
            return list2;
        }
        if (statements.size() == 1 && (result2 = this.handleSingleStatement(statements.get(0))) != null) {
            List<PreContract> list3 = result2;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
            }
            return list3;
        }
        List<PreContract> list4 = this.visitStatements(Collections.singletonList(StandardMethodContract.createConstraintArray(this.getParameters().size())), statements);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
        }
        return list4;
    }

    @Nullable
    private List<PreContract> handleSingleStatement(LighterASTNode statement2) {
        if (statement2.getTokenType() == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode returned = JavaLightTreeUtil.findExpressionChild(this.myTree, statement2);
            return this.getLiteralConstraint(returned) != null ? Collections.emptyList() : this.handleDelegation(returned, false);
        }
        if (statement2.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expr = JavaLightTreeUtil.findExpressionChild(this.myTree, statement2);
            return expr != null && expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION ? this.handleDelegation(expr, false) : null;
        }
        return null;
    }

    @Nullable
    private LighterASTNode getCodeBlock(@Nullable LighterASTNode parent) {
        return LightTreeUtil.firstChildOfType(this.myTree, parent, (IElementType)JavaElementType.CODE_BLOCK);
    }

    @NotNull
    static List<LighterASTNode> getStatements(@Nullable LighterASTNode codeBlock, LighterAST tree) {
        List<LighterASTNode> list2 = codeBlock == null ? Collections.emptyList() : LightTreeUtil.getChildrenOfType(tree, codeBlock, ElementType.JAVA_STATEMENT_BIT_SET);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getStatements"));
        }
        return list2;
    }

    @Nullable
    private List<PreContract> handleDelegation(@Nullable LighterASTNode expression2, boolean negated) {
        if (expression2 == null) {
            return null;
        }
        if (expression2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), negated);
        }
        if (this.isNegationExpression(expression2)) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression2), !negated);
        }
        if (expression2.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new DelegationContract(ExpressionRange.create(expression2, this.myBody.getStartOffset()), negated));
        }
        return null;
    }

    private boolean isNegationExpression(@Nullable LighterASTNode expression2) {
        return expression2 != null && expression2.getTokenType() == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType(this.myTree, expression2, JavaTokenType.EXCL) != null;
    }

    @NotNull
    private List<PreContract> visitExpression(List<MethodContract.ValueConstraint[]> states, @Nullable LighterASTNode expr) {
        int parameter;
        if (expr == null) {
            List<PreContract> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list2;
        }
        if (states.isEmpty()) {
            List<PreContract> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list3;
        }
        if (states.size() > 300) {
            List<PreContract> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list4;
        }
        IElementType type2 = expr.getTokenType();
        if (type2 == JavaElementType.POLYADIC_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION) {
            List<PreContract> list5 = this.visitPolyadic(states, expr);
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list5;
        }
        if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children2 = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
            if (children2.size() != 3) {
                List<PreContract> list6 = Collections.emptyList();
                if (list6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
                }
                return list6;
            }
            List<PreContract> conditionResults = this.visitExpression(states, children2.get(0));
            List list7 = ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), children2.get(1)), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), children2.get(2)));
            if (list7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list7;
        }
        if (type2 == JavaElementType.PARENTH_EXPRESSION) {
            List<PreContract> list8 = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list8 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list8;
        }
        if (type2 == JavaElementType.TYPE_CAST_EXPRESSION) {
            List<PreContract> list9 = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list9;
        }
        if (this.isNegationExpression(expr)) {
            List list10 = ContainerUtil.mapNotNull(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr)), PreContract::negate);
            if (list10 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list10;
        }
        if (type2 == JavaElementType.INSTANCE_OF_EXPRESSION && (parameter = this.resolveParameter(JavaLightTreeUtil.findExpressionChild(this.myTree, expr))) >= 0) {
            List<PreContract> list11 = ContractInferenceInterpreter.asPreContracts(ContainerUtil.mapNotNull(states, state -> ContractInferenceInterpreter.contractWithConstraint(state, parameter, MethodContract.ValueConstraint.NULL_VALUE, MethodContract.ValueConstraint.FALSE_VALUE)));
            if (list11 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list11;
        }
        if (type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.THIS_EXPRESSION) {
            List<PreContract> list12 = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.NOT_NULL_VALUE));
            if (list12 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list12;
        }
        if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            List<PreContract> list13 = Collections.singletonList(new MethodCallContract(ExpressionRange.create(expr, this.myBody.getStartOffset()), ContainerUtil.map(states, Arrays::asList)));
            if (list13 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list13;
        }
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(expr);
        if (constraint != null) {
            List<PreContract> list14 = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, constraint));
            if (list14 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list14;
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] != MethodContract.ValueConstraint.ANY_VALUE) {
                    result2.add(new StandardMethodContract(state2, state2[paramIndex]));
                    continue;
                }
                if (JavaTokenType.BOOLEAN_KEYWORD != this.getPrimitiveParameterType(paramIndex)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.TRUE_VALUE, MethodContract.ValueConstraint.TRUE_VALUE));
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.FALSE_VALUE, MethodContract.ValueConstraint.FALSE_VALUE));
            }
            List<PreContract> list15 = ContractInferenceInterpreter.asPreContracts(result2);
            if (list15 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list15;
        }
        List<PreContract> list16 = Collections.emptyList();
        if (list16 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
        }
        return list16;
    }

    @NotNull
    private List<PreContract> visitPolyadic(List<MethodContract.ValueConstraint[]> states, @NotNull LighterASTNode expr) {
        boolean logicalAnd;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
        }
        if (LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.PLUS) != null) {
            List<PreContract> list2 = ContractInferenceInterpreter.asPreContracts(ContainerUtil.map(states, s -> new StandardMethodContract((MethodContract.ValueConstraint[])s, MethodContract.ValueConstraint.NOT_NULL_VALUE)));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
            }
            return list2;
        }
        List<LighterASTNode> operands2 = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
        if (operands2.size() == 2) {
            boolean equality;
            boolean bl = equality = LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.EQEQ) != null;
            if (equality || LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.NE) != null) {
                List<PreContract> list3 = ContractInferenceInterpreter.asPreContracts(this.visitEqualityComparison(states, operands2.get(0), operands2.get(1), equality));
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
                }
                return list3;
            }
        }
        boolean bl = logicalAnd = LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.ANDAND) != null;
        if (logicalAnd || LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.OROR) != null) {
            List<PreContract> list4 = ContractInferenceInterpreter.asPreContracts(this.visitLogicalOperation(operands2, logicalAnd, states));
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
            }
            return list4;
        }
        List<PreContract> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
        }
        return list5;
    }

    @NotNull
    private static List<PreContract> asPreContracts(List<StandardMethodContract> contracts2) {
        List list2 = ContainerUtil.map(contracts2, KnownContract::new);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "asPreContracts"));
        }
        return list2;
    }

    @Nullable
    private static StandardMethodContract contractWithConstraint(MethodContract.ValueConstraint[] state, int parameter, MethodContract.ValueConstraint paramConstraint, MethodContract.ValueConstraint returnValue) {
        MethodContract.ValueConstraint[] newState = ContractInferenceInterpreter.withConstraint(state, parameter, paramConstraint);
        return newState == null ? null : new StandardMethodContract(newState, returnValue);
    }

    private List<StandardMethodContract> visitEqualityComparison(List<MethodContract.ValueConstraint[]> states, LighterASTNode op1, LighterASTNode op2, boolean equality) {
        int parameter = this.resolveParameter(op1);
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(op2);
        if (parameter < 0 || constraint == null) {
            parameter = this.resolveParameter(op2);
            constraint = this.getLiteralConstraint(op1);
        }
        if (parameter >= 0 && constraint != null) {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state : states) {
                if (constraint == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getPrimitiveParameterType(parameter) != null) continue;
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, MethodContract.ValueConstraint.NULL_VALUE, equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, constraint, equality ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE));
                ContainerUtil.addIfNotNull((Collection)result2, (Object)ContractInferenceInterpreter.contractWithConstraint(state, parameter, constraint.negate(), equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
            }
            return result2;
        }
        return Collections.emptyList();
    }

    @Nullable
    private IElementType getPrimitiveParameterType(int paramIndex) {
        LighterASTNode typeElement = LightTreeUtil.firstChildOfType(this.myTree, this.getParameters().get(paramIndex), JavaElementType.TYPE);
        LighterASTNode primitive = LightTreeUtil.firstChildOfType(this.myTree, typeElement, ElementType.PRIMITIVE_TYPE_BIT_SET);
        return primitive == null ? null : primitive.getTokenType();
    }

    static List<StandardMethodContract> toContracts(List<MethodContract.ValueConstraint[]> states, MethodContract.ValueConstraint constraint) {
        return ContainerUtil.map(states, state -> new StandardMethodContract((MethodContract.ValueConstraint[])state, constraint));
    }

    private List<StandardMethodContract> visitLogicalOperation(List<LighterASTNode> operands2, boolean conjunction, List<MethodContract.ValueConstraint[]> states) {
        MethodContract.ValueConstraint breakValue = conjunction ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE;
        ArrayList finalStates = ContainerUtil.newArrayList();
        for (LighterASTNode operand2 : operands2) {
            List<PreContract> opResults = this.visitExpression(states, operand2);
            finalStates.addAll(ContainerUtil.filter(ContractInferenceInterpreter.knownContracts(opResults), contract -> contract.returnValue == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, breakValue.negate());
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, breakValue.negate()));
        return finalStates;
    }

    private static List<StandardMethodContract> knownContracts(List<PreContract> values) {
        return ContainerUtil.mapNotNull(values, pc -> pc instanceof KnownContract ? ((KnownContract)pc).getContract() : null);
    }

    private static List<MethodContract.ValueConstraint[]> antecedentsReturning(List<PreContract> values, MethodContract.ValueConstraint result2) {
        return ContainerUtil.mapNotNull(ContractInferenceInterpreter.knownContracts(values), contract -> contract.returnValue == result2 ? contract.arguments : null);
    }

    @NotNull
    private List<PreContract> visitStatements(List<MethodContract.ValueConstraint[]> states, List<LighterASTNode> statements) {
        CodeBlockContracts result2 = new CodeBlockContracts();
        for (LighterASTNode statement2 : statements) {
            List<PreContract> conditionResults;
            IElementType type2 = statement2.getTokenType();
            if (type2 == JavaElementType.BLOCK_STATEMENT) {
                result2.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(this.getCodeBlock(statement2), this.myTree)));
                break;
            }
            if (type2 == JavaElementType.IF_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement2));
                List<LighterASTNode> thenElse = ContractInferenceInterpreter.getStatements(statement2, this.myTree);
                if (thenElse.size() > 0) {
                    result2.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), Collections.singletonList(thenElse.get(0))));
                }
                List<MethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE);
                if (thenElse.size() > 1) {
                    result2.addAll(this.visitStatements(falseStates, Collections.singletonList(thenElse.get(1))));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (type2 == JavaElementType.WHILE_STATEMENT) {
                states = ContractInferenceInterpreter.antecedentsReturning(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement2)), MethodContract.ValueConstraint.FALSE_VALUE);
                continue;
            }
            if (type2 == JavaElementType.THROW_STATEMENT) {
                result2.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type2 == JavaElementType.RETURN_STATEMENT) {
                result2.addAll(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement2)));
                break;
            }
            if (type2 == JavaElementType.ASSERT_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement2));
                result2.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type2 == JavaElementType.DECLARATION_STATEMENT) {
                result2.registerDeclaration(statement2, this.myTree, this.myBody.getStartOffset());
                continue;
            }
            if (type2 != JavaElementType.DO_WHILE_STATEMENT) break;
            result2.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(statement2, this.myTree)));
            break;
        }
        List<PreContract> list2 = result2.accumulated;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitStatements"));
        }
        return list2;
    }

    @Nullable
    private MethodContract.ValueConstraint getLiteralConstraint(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION) {
            return ContractInferenceInterpreter.getLiteralConstraint(((LighterASTNode)this.myTree.getChildren(expr).get(0)).getTokenType());
        }
        return null;
    }

    @NotNull
    static MethodContract.ValueConstraint getLiteralConstraint(@NotNull IElementType literalTokenType) {
        if (literalTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalTokenType", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
        }
        if (literalTokenType.equals(JavaTokenType.TRUE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.TRUE_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.FALSE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.FALSE_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.NULL_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NULL_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NOT_NULL_VALUE;
        if (valueConstraint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
        }
        return valueConstraint;
    }

    private int resolveParameter(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.myTree, expr) == null) {
            String name2 = JavaLightTreeUtil.getNameIdentifierText(this.myTree, expr);
            if (name2 == null) {
                return -1;
            }
            List<LighterASTNode> parameters2 = this.getParameters();
            for (int i2 = 0; i2 < parameters2.size(); ++i2) {
                if (!name2.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, parameters2.get(i2)))) continue;
                return i2;
            }
        }
        return -1;
    }

    @Nullable
    static MethodContract.ValueConstraint[] withConstraint(MethodContract.ValueConstraint[] constraints, int index, MethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        MethodContract.ValueConstraint negated = constraint.negate();
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        MethodContract.ValueConstraint[] copy = (MethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }

    private static class CodeBlockContracts {
        List<PreContract> accumulated = new ArrayList<PreContract>();
        List<ExpressionRange> varInitializers = new ArrayList<ExpressionRange>();

        private CodeBlockContracts() {
        }

        void addAll(List<PreContract> contracts2) {
            if (contracts2.isEmpty()) {
                return;
            }
            if (this.varInitializers.isEmpty()) {
                this.accumulated.addAll(contracts2);
            } else {
                this.accumulated.add(new SideEffectFilter(this.varInitializers, contracts2));
            }
        }

        void registerDeclaration(@NotNull LighterASTNode declStatement, @NotNull LighterAST tree, int scopeStart) {
            if (declStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declStatement", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter$CodeBlockContracts", "registerDeclaration"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter$CodeBlockContracts", "registerDeclaration"));
            }
            for (LighterASTNode var : LightTreeUtil.getChildrenOfType(tree, declStatement, JavaElementType.LOCAL_VARIABLE)) {
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild(tree, var);
                if (initializer == null) continue;
                this.varInitializers.add(ExpressionRange.create(initializer, scopeStart));
            }
        }
    }
}

