/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRangeValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaFactType<T>
extends Key<T> {
    private static final List<DfaFactType<?>> ourFactTypes = new ArrayList();
    public static final DfaFactType<Boolean> CAN_BE_NULL = new DfaFactType<Boolean>("Can be null"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "Nullable" : "NotNull";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaConstValue) {
                return ((DfaConstValue)value2).getValue() == null;
            }
            if (value2 instanceof DfaBoxedValue || value2 instanceof DfaUnboxedValue || value2 instanceof DfaRangeValue) {
                return false;
            }
            if (value2 instanceof DfaTypeValue) {
                return NullnessUtil.toBoolean(((DfaTypeValue)value2).getNullness());
            }
            return null;
        }

        @Override
        @Nullable
        Boolean calcFromVariable(@NotNull DfaVariableValue value2) {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactType$1", "calcFromVariable"));
            }
            return NullnessUtil.calcCanBeNull(value2);
        }
    };
    public static final DfaFactType<Boolean> OPTIONAL_PRESENCE = new DfaFactType<Boolean>("Optional presense"){

        @Override
        String toString(Boolean fact) {
            return fact != false ? "present Optional" : "absent Optional";
        }

        @Override
        @Nullable
        Boolean fromDfaValue(DfaValue value2) {
            return value2 instanceof DfaOptionalValue ? Boolean.valueOf(((DfaOptionalValue)value2).isPresent()) : null;
        }
    };
    public static final DfaFactType<LongRangeSet> RANGE = new DfaFactType<LongRangeSet>("Range"){

        @Override
        boolean isSuper(@NotNull LongRangeSet superFact, @NotNull LongRangeSet subFact) {
            if (superFact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFact", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "isSuper"));
            }
            if (subFact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subFact", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "isSuper"));
            }
            return superFact.contains(subFact);
        }

        @Override
        @Nullable
        LongRangeSet fromDfaValue(DfaValue value2) {
            if (value2 instanceof DfaVariableValue) {
                return this.calcFromVariable((DfaVariableValue)value2);
            }
            return LongRangeSet.fromDfaValue(value2);
        }

        @Override
        @Nullable
        LongRangeSet calcFromVariable(@NotNull DfaVariableValue var) {
            if (var == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "calcFromVariable"));
            }
            if (var.getQualifier() != null) {
                for (SpecialField sf : SpecialField.values()) {
                    if (!sf.isMyAccessor(var.getPsiVariable())) continue;
                    return sf.getRange();
                }
            }
            return LongRangeSet.fromType(var.getVariableType());
        }

        @Override
        @Nullable
        LongRangeSet intersectFacts(@NotNull LongRangeSet left, @NotNull LongRangeSet right) {
            if (left == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "intersectFacts"));
            }
            if (right == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/codeInspection/dataFlow/DfaFactType$3", "intersectFacts"));
            }
            LongRangeSet intersection = left.intersect(right);
            return intersection.isEmpty() ? null : intersection;
        }

        @Override
        String toString(LongRangeSet fact) {
            return fact.toString();
        }
    };

    private DfaFactType(String name2) {
        super("DfaFactType: " + name2);
        ourFactTypes.add(this);
    }

    @Nullable
    T fromDfaValue(DfaValue value2) {
        return null;
    }

    @Nullable
    T calcFromVariable(@NotNull DfaVariableValue value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/DfaFactType", "calcFromVariable"));
        }
        return null;
    }

    boolean isSuper(@NotNull T superFact, @NotNull T subFact) {
        if (superFact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superFact", "com/intellij/codeInspection/dataFlow/DfaFactType", "isSuper"));
        }
        if (subFact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subFact", "com/intellij/codeInspection/dataFlow/DfaFactType", "isSuper"));
        }
        return false;
    }

    @Nullable
    T intersectFacts(@NotNull T left, @NotNull T right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/codeInspection/dataFlow/DfaFactType", "intersectFacts"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/codeInspection/dataFlow/DfaFactType", "intersectFacts"));
        }
        return (T)(left.equals(right) ? left : null);
    }

    String toString(T fact) {
        return fact.toString();
    }

    static List<DfaFactType<?>> getTypes() {
        return Collections.unmodifiableList(ourFactTypes);
    }
}

