/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullnessUtil {
    static Boolean calcCanBeNull(DfaVariableValue value2) {
        PsiType itemType;
        PsiExpression iteratedValue2;
        PsiModifierListOwner var = value2.getPsiVariable();
        Nullness nullability = DfaPsiUtil.getElementNullability(value2.getVariableType(), var);
        if (nullability != Nullness.UNKNOWN) {
            return NullnessUtil.toBoolean(nullability);
        }
        Nullness defaultNullability = value2.getFactory().suggestNullabilityForNonAnnotatedMember(var);
        if (var instanceof PsiParameter && var.getParent() instanceof PsiForeachStatement && (iteratedValue2 = ((PsiForeachStatement)var.getParent()).getIteratedValue()) != null && (itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2)) != null) {
            return NullnessUtil.toBoolean(DfaPsiUtil.getElementNullability(itemType, var));
        }
        if (var instanceof PsiField && value2.getFactory().isHonorFieldInitializers()) {
            return NullnessUtil.toBoolean(NullnessUtil.getNullabilityFromFieldInitializers((PsiField)var, defaultNullability));
        }
        return NullnessUtil.toBoolean(defaultNullability);
    }

    private static Nullness getNullabilityFromFieldInitializers(PsiField field, Nullness defaultNullability) {
        if (DfaPsiUtil.isFinalField((PsiVariable)field)) {
            PsiExpression initializer = field.getInitializer();
            if (initializer != null) {
                return NullnessUtil.getExpressionNullness(initializer);
            }
            List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
            if (initializers.isEmpty()) {
                return defaultNullability;
            }
            for (PsiExpression expression2 : initializers) {
                if (NullnessUtil.getExpressionNullness(expression2) != Nullness.NULLABLE) continue;
                return Nullness.NULLABLE;
            }
            if (DfaPsiUtil.isInitializedNotNull(field)) {
                return Nullness.NOT_NULL;
            }
        } else if (NullnessUtil.isOnlyImplicitlyInitialized(field)) {
            return Nullness.NOT_NULL;
        }
        return defaultNullability;
    }

    private static boolean isOnlyImplicitlyInitialized(PsiField field) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)(NullnessUtil.isImplicitlyInitializedNotNull(field) && NullnessUtil.weAreSureThereAreNoExplicitWrites(field) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static boolean isImplicitlyInitializedNotNull(PsiField field) {
        return ContainerUtil.exists((Object[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME), p -> p.isImplicitlyNotNullInitialized((PsiElement)field));
    }

    private static boolean weAreSureThereAreNoExplicitWrites(PsiField field) {
        String name2 = field.getName();
        if (name2 == null || field.getInitializer() != null) {
            return false;
        }
        if (!NullnessUtil.isCheapEnoughToSearch(field, name2)) {
            return false;
        }
        return ReferencesSearch.search((PsiElement)field).forEach(reference -> reference instanceof PsiReferenceExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiReferenceExpression)reference)));
    }

    private static boolean isCheapEnoughToSearch(PsiField field, String name2) {
        SearchScope scope = field.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return true;
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)field.getProject());
        PsiSearchHelper.SearchCostResult result2 = helper.isCheapEnoughToSearch(name2, (GlobalSearchScope)scope, field.getContainingFile(), null);
        return result2 != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static Nullness getExpressionNullness(@Nullable PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) == null) {
            return Nullness.UNKNOWN;
        }
        if (expression2.textMatches((CharSequence)"null")) {
            return Nullness.NULLABLE;
        }
        if (expression2 instanceof PsiNewExpression || expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiPolyadicExpression || expression2 instanceof PsiFunctionalExpression || expression2.getType() instanceof PsiPrimitiveType) {
            return Nullness.NOT_NULL;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                return Nullness.UNKNOWN;
            }
            Nullness left = NullnessUtil.getExpressionNullness(thenExpression2);
            if (left == Nullness.UNKNOWN) {
                return Nullness.UNKNOWN;
            }
            Nullness right = NullnessUtil.getExpressionNullness(elseExpression2);
            return left == right ? left : Nullness.UNKNOWN;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            return NullnessUtil.getExpressionNullness(((PsiTypeCastExpression)expression2).getOperand());
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target2 = ((PsiReferenceExpression)expression2).resolve();
            return DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)target2);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression2).resolveMethod();
            return method != null ? DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)method) : Nullness.UNKNOWN;
        }
        return Nullness.UNKNOWN;
    }

    @NotNull
    public static Nullness fromBoolean(@Nullable Boolean fact) {
        Nullness nullness = fact == null ? Nullness.UNKNOWN : (fact != false ? Nullness.NULLABLE : Nullness.NOT_NULL);
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullnessUtil", "fromBoolean"));
        }
        return nullness;
    }

    @Nullable
    public static Boolean toBoolean(@NotNull Nullness nullness) {
        if (nullness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/NullnessUtil", "toBoolean"));
        }
        return nullness == Nullness.UNKNOWN ? null : Boolean.valueOf(nullness == Nullness.NULLABLE);
    }
}

