/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class StandardMethodContract
extends MethodContract {
    public final MethodContract.ValueConstraint[] arguments;
    public final MethodContract.ValueConstraint returnValue;

    public StandardMethodContract(@NotNull MethodContract.ValueConstraint[] arguments, @NotNull MethodContract.ValueConstraint returnValue) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInspection/dataFlow/StandardMethodContract", "<init>"));
        }
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnValue", "com/intellij/codeInspection/dataFlow/StandardMethodContract", "<init>"));
        }
        this.arguments = arguments;
        this.returnValue = returnValue;
    }

    @Override
    public MethodContract.ValueConstraint getReturnValue() {
        return this.returnValue;
    }

    @NotNull
    static MethodContract.ValueConstraint[] createConstraintArray(int paramCount) {
        MethodContract.ValueConstraint[] args = new MethodContract.ValueConstraint[paramCount];
        for (int i2 = 0; i2 < args.length; ++i2) {
            args[i2] = MethodContract.ValueConstraint.ANY_VALUE;
        }
        if (args == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardMethodContract", "createConstraintArray"));
        }
        return args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        StandardMethodContract contract = (StandardMethodContract)o;
        if (!Arrays.equals((Object[])this.arguments, (Object[])contract.arguments)) {
            return false;
        }
        return this.returnValue == contract.returnValue;
    }

    public int hashCode() {
        int result2 = 0;
        for (MethodContract.ValueConstraint argument : this.arguments) {
            result2 = 31 * result2 + argument.ordinal();
        }
        result2 = 31 * result2 + this.returnValue.ordinal();
        return result2;
    }

    @Override
    String getArgumentsPresentation() {
        return StringUtil.join((Object[])this.arguments, constraint -> constraint.toString(), (String)", ");
    }

    @Override
    protected List<ContractValue> getConditions() {
        return IntStreamEx.ofIndices((Object[])this.arguments).mapToObj(idx -> this.arguments[idx].getCondition(idx)).without((Object)ContractValue.booleanValue(true)).toList();
    }

    public static List<StandardMethodContract> parseContract(String text2) throws ParseException {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String clause : StringUtil.replace((String)text2, (String)" ", (String)"").split(";")) {
            MethodContract.ValueConstraint[] args;
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw new ParseException("A contract clause must be in form arg1, ..., argN -> return-value");
            }
            String beforeArrow = clause.substring(0, arrowIndex);
            if (StringUtil.isNotEmpty((String)beforeArrow)) {
                String[] argStrings = beforeArrow.split(",");
                args = new MethodContract.ValueConstraint[argStrings.length];
                for (int i2 = 0; i2 < args.length; ++i2) {
                    args[i2] = StandardMethodContract.parseConstraint(argStrings[i2]);
                }
            } else {
                args = new MethodContract.ValueConstraint[]{};
            }
            result2.add(new StandardMethodContract(args, StandardMethodContract.parseConstraint(clause.substring(arrowIndex + arrow.length()))));
        }
        return result2;
    }

    private static MethodContract.ValueConstraint parseConstraint(String name2) throws ParseException {
        if (StringUtil.isEmpty((String)name2)) {
            throw new ParseException("Constraint should not be empty");
        }
        for (MethodContract.ValueConstraint constraint : MethodContract.ValueConstraint.values()) {
            if (!constraint.toString().equals(name2)) continue;
            return constraint;
        }
        throw new ParseException("Constraint should be one of: null, !null, true, false, fail, _. Found: " + name2);
    }

    public static class ParseException
    extends Exception {
        private ParseException(String message2) {
            super(message2);
        }
    }
}

