/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaRelationValue
extends DfaValue {
    private DfaValue myLeftOperand;
    private DfaValue myRightOperand;
    private RelationType myRelation;

    @Override
    public DfaRelationValue createNegated() {
        return this.myFactory.getRelationFactory().createCanonicalRelation(this.myLeftOperand, this.myRelation.getNegated(), this.myRightOperand);
    }

    private DfaRelationValue(DfaValue leftOperand2, DfaValue rightOperand2, RelationType relationType, DfaValueFactory factory) {
        super(factory);
        this.myLeftOperand = leftOperand2;
        this.myRightOperand = rightOperand2;
        this.myRelation = relationType;
    }

    public DfaValue getLeftOperand() {
        return this.myLeftOperand;
    }

    public DfaValue getRightOperand() {
        return this.myRightOperand;
    }

    public boolean isEquality() {
        return this.myRelation == RelationType.EQ;
    }

    public boolean isNonEquality() {
        return this.myRelation == RelationType.NE || this.myRelation == RelationType.GT || this.myRelation == RelationType.LT;
    }

    @NotNull
    public RelationType getRelation() {
        RelationType relationType = this.myRelation;
        if (relationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue", "getRelation"));
        }
        return relationType;
    }

    @NonNls
    public String toString() {
        return this.myLeftOperand + " " + (Object)((Object)this.myRelation) + " " + this.myRightOperand;
    }

    public static class Factory {
        private final Map<Trinity<DfaValue, DfaValue, RelationType>, DfaRelationValue> myValues;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.myValues = new HashMap();
        }

        public DfaRelationValue createRelation(DfaValue dfaLeft, RelationType relationType, DfaValue dfaRight) {
            if ((relationType == RelationType.IS || relationType == RelationType.IS_NOT) && dfaRight instanceof DfaOptionalValue) {
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue || dfaRight instanceof DfaVariableValue || dfaRight instanceof DfaBoxedValue || dfaRight instanceof DfaUnboxedValue) {
                if (!(dfaLeft instanceof DfaVariableValue || dfaLeft instanceof DfaBoxedValue || dfaLeft instanceof DfaUnboxedValue)) {
                    RelationType flipped = relationType.getFlipped();
                    return flipped == null ? null : this.createCanonicalRelation(dfaRight, flipped, dfaLeft);
                }
                return this.createCanonicalRelation(dfaLeft, relationType, dfaRight);
            }
            if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaConstValue) {
                return this.createCanonicalRelation(DfaUnknownValue.getInstance(), relationType, dfaRight);
            }
            if (dfaRight instanceof DfaTypeValue && dfaLeft instanceof DfaConstValue) {
                return this.createCanonicalRelation(DfaUnknownValue.getInstance(), relationType, dfaLeft);
            }
            return null;
        }

        @NotNull
        private DfaRelationValue createCanonicalRelation(@NotNull DfaValue dfaLeft, @NotNull RelationType relationType, @NotNull DfaValue dfaRight) {
            if (dfaLeft == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            if (relationType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relationType", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            if (dfaRight == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            DfaRelationValue dfaRelationValue = this.myValues.computeIfAbsent((Trinity<DfaValue, DfaValue, RelationType>)Trinity.create((Object)dfaLeft, (Object)dfaRight, (Object)((Object)relationType)), k -> {
                if (dfaLeft == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaLeft", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "lambda$createCanonicalRelation$0"));
                }
                if (dfaRight == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaRight", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "lambda$createCanonicalRelation$0"));
                }
                if (relationType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relationType", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "lambda$createCanonicalRelation$0"));
                }
                return new DfaRelationValue(dfaLeft, dfaRight, relationType, this.myFactory);
            });
            if (dfaRelationValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$Factory", "createCanonicalRelation"));
            }
            return dfaRelationValue;
        }
    }

    public static enum RelationType {
        LE("<="),
        LT("<"),
        GE(">="),
        GT(">"),
        EQ("=="),
        NE("!="),
        IS("is"),
        IS_NOT("isn't");

        private final String myName;

        private RelationType(String name2) {
            this.myName = name2;
        }

        @NotNull
        public RelationType getNegated() {
            switch (this) {
                case LE: {
                    RelationType relationType = GT;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case LT: {
                    RelationType relationType = GE;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case GE: {
                    RelationType relationType = LT;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case GT: {
                    RelationType relationType = LE;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case EQ: {
                    RelationType relationType = NE;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case NE: {
                    RelationType relationType = EQ;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case IS: {
                    RelationType relationType = IS_NOT;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
                case IS_NOT: {
                    RelationType relationType = IS;
                    if (relationType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaRelationValue$RelationType", "getNegated"));
                    }
                    return relationType;
                }
            }
            throw new InternalError("Unexpected enum value: " + (Object)((Object)this));
        }

        @Nullable
        public RelationType getFlipped() {
            switch (this) {
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
                case EQ: 
                case NE: {
                    return this;
                }
            }
            return null;
        }

        public String toString() {
            return this.myName;
        }

        @Nullable
        public static RelationType fromElementType(IElementType type2) {
            if (JavaTokenType.EQEQ.equals(type2)) {
                return EQ;
            }
            if (JavaTokenType.NE.equals(type2)) {
                return NE;
            }
            if (JavaTokenType.LT.equals(type2)) {
                return LT;
            }
            if (JavaTokenType.GT.equals(type2)) {
                return GT;
            }
            if (JavaTokenType.LE.equals(type2)) {
                return LE;
            }
            if (JavaTokenType.GE.equals(type2)) {
                return GE;
            }
            if (JavaTokenType.INSTANCEOF_KEYWORD.equals(type2)) {
                return IS;
            }
            return null;
        }

        public static RelationType equivalence(boolean equal) {
            return equal ? EQ : NE;
        }
    }
}

