/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DfaTypeValue
extends DfaValue {
    @NotNull
    private final DfaPsiType myType;
    @NotNull
    private final Nullness myNullness;

    private DfaTypeValue(@NotNull DfaPsiType type2, @NotNull Nullness nullness, @NotNull DfaValueFactory factory) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue", "<init>"));
        }
        if (nullness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue", "<init>"));
        }
        super(factory);
        this.myType = type2;
        this.myNullness = nullness;
    }

    @NotNull
    public DfaPsiType getDfaType() {
        DfaPsiType dfaPsiType = this.myType;
        if (dfaPsiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue", "getDfaType"));
        }
        return dfaPsiType;
    }

    public boolean isNullable() {
        return this.myNullness == Nullness.NULLABLE;
    }

    public boolean isNotNull() {
        return this.myNullness == Nullness.NOT_NULL;
    }

    @NotNull
    public Nullness getNullness() {
        Nullness nullness = this.myNullness;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue", "getNullness"));
        }
        return nullness;
    }

    public DfaTypeValue withNullness(Nullness nullness) {
        return nullness == this.myNullness ? this : this.myFactory.getTypeFactory().createTypeValue(this.myType, nullness);
    }

    @NonNls
    public String toString() {
        return this.myType + ", nullable=" + (Object)((Object)this.myNullness);
    }

    public static class Factory {
        private final Map<DfaPsiType, ArrayList<DfaTypeValue>> myCache;
        @NotNull
        private final DfaValueFactory myFactory;

        Factory(@NotNull DfaValueFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "<init>"));
            }
            this.myCache = ContainerUtil.newHashMap();
            this.myFactory = factory;
        }

        @NotNull
        DfaTypeValue createTypeValue(@NotNull DfaPsiType type2, @NotNull Nullness nullness) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            if (nullness == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            ArrayList<DfaTypeValue> conditions = this.myCache.get(type2);
            if (conditions == null) {
                conditions = new ArrayList();
                this.myCache.put(type2, conditions);
            } else {
                for (DfaTypeValue aType : conditions) {
                    if (aType.myNullness != nullness) continue;
                    DfaTypeValue dfaTypeValue = aType;
                    if (dfaTypeValue == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
                    }
                    return dfaTypeValue;
                }
            }
            DfaTypeValue result2 = new DfaTypeValue(type2, nullness, this.myFactory);
            conditions.add(result2);
            DfaTypeValue dfaTypeValue = result2;
            if (dfaTypeValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory", "createTypeValue"));
            }
            return dfaTypeValue;
        }
    }
}

