/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.equalsAndHashcode.EqualsAndHashcodeBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsAndHashcode
extends EqualsAndHashcodeBase {
    @Override
    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        if (!isOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new GenerateEqualsHashcodeFix(hasEquals)};
    }

    private static class GenerateEqualsHashcodeFix
    implements LocalQuickFix {
        private final boolean myHasEquals;

        public GenerateEqualsHashcodeFix(boolean hasEquals) {
            this.myHasEquals = hasEquals;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myHasEquals ? InspectionsBundle.message((String)"inspection.equals.hashcode.generate.hashcode.quickfix", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.equals.hashcode.generate.equals.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix", "applyFix"));
            }
            Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            new GenerateEqualsHandler().invoke(project2, editor, element.getContainingFile());
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcode$GenerateEqualsHashcodeFix", "getElementToMakeWritable"));
            }
            return currentFile;
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

