/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DescriptorComposer
extends HTMLComposerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.DescriptorComposer");
    private final InspectionToolPresentation myTool;

    public DescriptorComposer(@NotNull InspectionToolPresentation tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/DescriptorComposer", "<init>"));
        }
        this.myTool = tool;
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refEntity) {
        this.genPageHeader(buf, refEntity);
        if (this.myTool.getDescriptions(refEntity) != null) {
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
            buf.append("<div class=\"problem-description\">");
            CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refEntity);
            LOG.assertTrue(descriptions != null);
            this.startList(buf);
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                this.startListItem(buf);
                this.composeDescription(description, i, buf, refEntity);
                DescriptorComposer.doneListItem(buf);
            }
            this.doneList(buf);
            buf.append("</div>");
            this.appendResolution(buf, refEntity, DescriptorComposer.quickFixTexts(refEntity, this.myTool));
        } else {
            this.appendNoProblems(buf);
        }
    }

    @NotNull
    public static String[] quickFixTexts(RefEntity where, @NotNull InspectionToolPresentation toolPresentation) {
        if (toolPresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolPresentation", "com/intellij/codeInspection/ex/DescriptorComposer", "quickFixTexts"));
        }
        QuickFixAction[] quickFixes = toolPresentation.getQuickFixes(new RefEntity[]{where}, null);
        ArrayList<String> texts = new ArrayList<String>();
        for (QuickFixAction quickFix : quickFixes) {
            String text2 = quickFix.getText();
            if (text2 == null) continue;
            texts.add(DescriptorComposer.escapeQuickFixText(text2));
        }
        String[] stringArray = ArrayUtil.toStringArray(texts);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/DescriptorComposer", "quickFixTexts"));
        }
        return stringArray;
    }

    private static String escapeQuickFixText(String text2) {
        return XmlStringUtil.isWrappedInHtml((String)text2) ? XmlStringUtil.stripHtml((String)text2) : StringUtil.escapeXml((String)text2);
    }

    protected void composeAdditionalDescription(@NotNull StringBuffer buf, @NotNull RefEntity refEntity) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/codeInspection/ex/DescriptorComposer", "composeAdditionalDescription"));
        }
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/ex/DescriptorComposer", "composeAdditionalDescription"));
        }
    }

    @Override
    public void compose(StringBuffer buf, RefEntity refElement, CommonProblemDescriptor descriptor) {
        CommonProblemDescriptor[] descriptions = this.myTool.getDescriptions(refElement);
        int problemIdx = 0;
        if (descriptions != null) {
            problemIdx = -1;
            for (int i = 0; i < descriptions.length; ++i) {
                CommonProblemDescriptor description = descriptions[i];
                if (description != descriptor) continue;
                problemIdx = i;
                break;
            }
            if (problemIdx == -1) {
                return;
            }
        }
        this.genPageHeader(buf, refElement);
        DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.synopsis", (Object[])new Object[0]));
        buf.append("<br>");
        DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
        this.composeDescription(descriptor, problemIdx, buf, refElement);
        if (refElement instanceof RefElement && !refElement.isValid()) {
            return;
        }
        QuickFix[] fixes = descriptor.getFixes();
        if (fixes != null && fixes.length > 0) {
            buf.append("<br><br>");
            DescriptorComposer.appendHeading((StringBuffer)buf, (String)InspectionsBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
            buf.append("<br>");
            DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            int idx = 0;
            for (QuickFix fix : fixes) {
                buf.append("<a HREF=\"file://bred.txt#invokelocal:" + idx++);
                buf.append("\">");
                buf.append(DescriptorComposer.escapeQuickFixText(fix.getName()));
                buf.append("</a>");
                buf.append("<br>");
                DescriptorComposer.appendAfterHeaderIndention((StringBuffer)buf);
            }
        }
    }

    protected void composeDescription(@NotNull CommonProblemDescriptor description, int i, @NotNull StringBuffer buf, @NotNull RefEntity refElement) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/codeInspection/ex/DescriptorComposer", "composeDescription"));
        }
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/codeInspection/ex/DescriptorComposer", "composeDescription"));
        }
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/ex/DescriptorComposer", "composeDescription"));
        }
        PsiElement expression2 = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement() : null;
        StringBuilder anchor = new StringBuilder();
        VirtualFile vFile = null;
        if (expression2 != null) {
            vFile = expression2.getContainingFile().getVirtualFile();
            if (vFile instanceof VirtualFileWindow) {
                vFile = ((VirtualFileWindow)vFile).getDelegate();
            }
            anchor.append("<a HREF=\"");
            anchor.append(DescriptorComposer.appendURL(vFile, "descr:" + i));
            anchor.append("\">");
            anchor.append(ProblemDescriptorUtil.extractHighlightedText(description, expression2).replaceAll("\\$", "\\\\\\$"));
            anchor.append("</a>");
        } else {
            anchor.append("<font style=\"font-weight:bold; color:#FF0000\";>");
            anchor.append(InspectionsBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor.append("</font>");
        }
        String descriptionTemplate = description.getDescriptionTemplate();
        if (XmlStringUtil.isWrappedInHtml((String)descriptionTemplate)) {
            descriptionTemplate = XmlStringUtil.stripHtml((String)descriptionTemplate);
        } else {
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"<code>", (String)"'");
            descriptionTemplate = StringUtil.replace((String)descriptionTemplate, (String)"</code>", (String)"'");
            descriptionTemplate = XmlStringUtil.escapeString((String)descriptionTemplate);
        }
        String reference = "#ref";
        boolean containsReference = descriptionTemplate.contains("#ref");
        String res = descriptionTemplate.replaceAll("#ref", anchor.toString());
        int lineNumber = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
        StringBuffer lineAnchor = new StringBuffer();
        if (expression2 != null && lineNumber >= 0) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            lineAnchor.append(InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            int offset = doc.getLineStartOffset(lineNumber);
            offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
            lineAnchor.append(DescriptorComposer.appendURL(vFile, String.valueOf(offset)));
            lineAnchor.append("\">");
            lineAnchor.append(Integer.toString(lineNumber + 1));
            lineAnchor.append("</a>");
            String location = "#loc";
            if (!res.contains("#loc")) {
                res = res + " (#loc)";
            }
            res = res.replaceAll("#loc", lineAnchor.toString());
        }
        buf.append(res.replace("#end", "").replace("#treeend", ""));
        buf.append("<br>").append("<br>");
        this.composeAdditionalDescription(buf, refElement);
    }

    private static String appendURL(VirtualFile vFile, String anchor) {
        return vFile.getUrl() + "#" + anchor;
    }
}

