/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InspectionRVContentProviderImpl
extends InspectionRVContentProvider {
    public InspectionRVContentProviderImpl(Project project2) {
        super(project2);
    }

    @Override
    public boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "checkReportedProblems"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "checkReportedProblems"));
        }
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        presentation.updateContent();
        SearchScope searchScope = context.getCurrentScope().toSearchScope();
        if (searchScope instanceof LocalSearchScope) {
            Map<String, Set<RefEntity>> contents = presentation.getContent();
            Map<RefEntity, CommonProblemDescriptor[]> problemElements = presentation.getProblemElements();
            for (Set<RefEntity> entities : contents.values()) {
                Iterator<RefEntity> iterator = entities.iterator();
                while (iterator.hasNext()) {
                    TextRange range;
                    PsiElement element;
                    RefEntity entity = iterator.next();
                    if (entity instanceof RefElement && (element = ((RefElement)entity).getElement()) != null && (range = element.getTextRange()) != null && ((LocalSearchScope)searchScope).containsRange(element.getContainingFile(), range)) continue;
                    problemElements.remove(entity);
                    iterator.remove();
                }
            }
        }
        return presentation.hasReportedProblems();
    }

    @Override
    @NotNull
    public QuickFixAction[] getQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "getQuickFixes"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "getQuickFixes"));
        }
        RefEntity[] refEntities = tree.getSelectedElements();
        InspectionToolPresentation presentation = tree.getContext().getPresentation(toolWrapper);
        QuickFixAction[] quickFixActionArray = refEntities.length == 0 ? QuickFixAction.EMPTY : presentation.getQuickFixes(refEntities, tree);
        if (quickFixActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "getQuickFixes"));
        }
        return quickFixActionArray;
    }

    @Override
    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity, @NotNull Map<String, Set<RefEntity>> contents, @NotNull Map<RefEntity, CommonProblemDescriptor[]> problems) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (toolNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendToolNodeContent"));
        }
        InspectionToolWrapper toolWrapper = toolNode.getToolWrapper();
        InspectionNode mergedToolNode = (InspectionNode)InspectionRVContentProviderImpl.merge(toolNode, parentNode, !groupBySeverity);
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        Set<RefModule> moduleProblems = presentation.getModuleProblems();
        if (!moduleProblems.isEmpty()) {
            HashSet entities = contents.get("");
            if (entities == null) {
                entities = new HashSet();
                contents.put("", entities);
            }
            entities.addAll(moduleProblems);
        }
        this.buildTree(context, contents, false, toolWrapper, refElement -> {
            if (problems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "lambda$appendToolNodeContent$0"));
            }
            return new InspectionRVContentProvider.RefEntityContainer<Object>((RefEntity)refElement, (Descriptor[])((Object[])problems.get(refElement)));
        }, showStructure, node -> InspectionRVContentProviderImpl.merge(node, mergedToolNode, true));
        return mergedToolNode;
    }

    @Override
    protected void appendDescriptor(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionRVContentProvider.RefEntityContainer container, @NotNull InspectionTreeNode pNode, boolean canPackageRepeat) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        if (pNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pNode", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "appendDescriptor"));
        }
        RefEntity refElement = container.getRefEntity();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        CommonProblemDescriptor[] problems = (CommonProblemDescriptor[])container.getDescriptors();
        if (problems != null) {
            RefElementNode elemNode = InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
            for (CommonProblemDescriptor problem : problems) {
                assert (problem != null);
                elemNode.insertByOrder((InspectionTreeNode)ReadAction.compute(() -> {
                    if (toolWrapper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/InspectionRVContentProviderImpl", "lambda$appendDescriptor$2"));
                    }
                    return new ProblemDescriptionNode(refElement, problem, toolWrapper, presentation);
                }), true);
                elemNode.setProblem(elemNode.getChildCount() == 1 ? problems[0] : null);
            }
        } else {
            HashSet currentEntities;
            Set<RefEntity> currentElements;
            if (canPackageRepeat && pNode instanceof InspectionPackageNode && (currentElements = presentation.getContent().get(((InspectionPackageNode)pNode).getPackageName())) != null && RefUtil.contains((RefEntity)refElement, (Collection)(currentEntities = new HashSet(currentElements)))) {
                return;
            }
            InspectionRVContentProviderImpl.addNodeToParent(container, presentation, pNode);
        }
    }
}

