/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HTMLExportUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(String folder, @NonNls String fileName, CharSequence buf, Project project2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        File fullPath = new File(folder + File.separator + fileName);
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message((String)"inspection.export.generating.html.for", (Object[])new Object[]{fullPath.getAbsolutePath()}));
        }
        try {
            OutputStreamWriter writer = null;
            try {
                File dir = fullPath.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    HTMLExportUtil.showErrorMessage("Can't create dir", dir, project2);
                    return;
                }
                if (!dir.canWrite() && !fullPath.canWrite()) {
                    HTMLExportUtil.showErrorMessage("Permission denied", fullPath, project2);
                    return;
                }
                writer = new FileWriter(fullPath, false);
                writer.write(buf.toString().toCharArray());
                return;
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            HTMLExportUtil.showErrorMessage(String.valueOf(e.getCause()), fullPath, project2);
        }
    }

    private static void showErrorMessage(@NotNull String message2, @NotNull File file2, @NotNull Project project2) {
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/export/HTMLExportUtil", "showErrorMessage"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/export/HTMLExportUtil", "showErrorMessage"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/export/HTMLExportUtil", "showErrorMessage"));
        }
        Runnable showError2 = () -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/export/HTMLExportUtil", "lambda$showErrorMessage$0"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/export/HTMLExportUtil", "lambda$showErrorMessage$0"));
            }
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInspection/export/HTMLExportUtil", "lambda$showErrorMessage$0"));
            }
            Messages.showMessageDialog((Project)project2, (String)InspectionsBundle.message((String)"inspection.export.error.writing.to", (Object[])new Object[]{file2.getAbsolutePath(), message2}), (String)InspectionsBundle.message((String)"inspection.export.results.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        };
        ApplicationManager.getApplication().invokeLater(showError2, ModalityState.NON_MODAL);
        throw new ProcessCanceledException();
    }
}

