/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MapForEachInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String JAVA_UTIL_MAP_ENTRY = "java.util.Map.Entry";
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_ENTRY_SET = CallMatcher.instanceCall("java.util.Map", "entrySet").parameterCount(0);
    private static final CallMatcher ENTRY_GETTER = CallMatcher.instanceCall("java.util.Map.Entry", "getValue", "getKey").parameterCount(0);
    public boolean DO_NOT_HIGHLIGHT_LOOP = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.map.foreach.option.no.loops", (Object[])new Object[0]), (InspectionProfileEntry)this, "DO_NOT_HIGHLIGHT_LOOP");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8MapForEachInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8MapForEachInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!ITERABLE_FOREACH.test(call)) {
                    return;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!MAP_ENTRY_SET.test(qualifierCall)) {
                    return;
                }
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
                if (lambda2 == null) {
                    return;
                }
                PsiParameter[] lambdaParameters = lambda2.getParameterList().getParameters();
                if (lambdaParameters.length != 1) {
                    return;
                }
                PsiParameter entry = lambdaParameters[0];
                if (!this.allUsagesAllowed(entry)) {
                    return;
                }
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                holder.registerProblem(nameElement, InspectionsBundle.message((String)"inspection.map.foreach.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithMapForEachFix()});
            }

            private boolean allUsagesAllowed(@NotNull PsiParameter entry) {
                if (entry == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/codeInspection/java18api/Java8MapForEachInspection$1", "allUsagesAllowed"));
                }
                return ReferencesSearch.search((PsiElement)entry).forEach(entryRef -> {
                    PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)ObjectUtils.tryCast((Object)entryRef.getElement(), PsiExpression.class));
                    return ENTRY_GETTER.test(entryCall);
                });
            }

            public void visitForeachStatement(PsiForeachStatement loop) {
                if (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP && !isOnTheFly) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
                if (MAP_ENTRY_SET.test(call) && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)loop.getBody()) && this.allUsagesAllowed(loop.getIterationParameter())) {
                    ProblemHighlightType type2 = Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    boolean wholeStatement = isOnTheFly && (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP || InspectionProjectProfileManager.isInformationLevel(Java8MapForEachInspection.this.getShortName(), (PsiElement)loop));
                    PsiJavaToken rParenth = loop.getRParenth();
                    PsiElement firstChild = loop.getFirstChild();
                    TextRange range = wholeStatement && rParenth != null ? new TextRange(0, rParenth.getStartOffsetInParent() + 1) : new TextRange(0, firstChild.getTextLength());
                    holder.registerProblem((ProblemDescriptor)new ProblemDescriptorBase(firstChild, firstChild, InspectionsBundle.message((String)"inspection.map.foreach.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithMapForEachFix()}, type2, false, range, type2 != ProblemHighlightType.INFORMATION, holder.isOnTheFly()));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8MapForEachInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static class ReplaceWithMapForEachFix
    implements LocalQuickFix {
        private ReplaceWithMapForEachFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.map.foreach.fix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8MapForEachInspection$ReplaceWithMapForEachFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8MapForEachInspection$ReplaceWithMapForEachFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8MapForEachInspection$ReplaceWithMapForEachFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element.getParent() instanceof PsiForeachStatement) {
                ReplaceWithMapForEachFix.fixInForeach((PsiForeachStatement)element.getParent());
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiMethodCallExpression entrySetCall = MethodCallUtils.getQualifierMethodCall(call);
            if (entrySetCall == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)args[0], PsiLambdaExpression.class);
            if (lambda2 == null) {
                return;
            }
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameterList parameterList = lambda2.getParameterList();
            PsiParameter[] lambdaParameters = parameterList.getParameters();
            if (lambdaParameters.length != 1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiParameter entryParameter = lambdaParameters[0];
            String replacement = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, body2, ct);
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        private static String createReplacementExpression(PsiMethodCallExpression entrySetCall, PsiParameter entryParameter, PsiElement body2, CommentTracker ct) {
            PsiType entryType = entryParameter.getType();
            ParameterCandidate key2 = new ParameterCandidate(entryType, true);
            ParameterCandidate value2 = new ParameterCandidate(entryType, false);
            Collection references = ReferencesSearch.search((PsiElement)entryParameter).findAll();
            for (Object ref : references) {
                PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class));
                if (!ENTRY_GETTER.test(entryCall)) continue;
                ParameterCandidate.select(entryCall, key2, value2).accept(entryCall);
            }
            key2.createName(body2, ct);
            value2.createName(body2, ct);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)entrySetCall.getProject());
            for (PsiReference ref : references) {
                PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)ref.getElement(), PsiExpression.class);
                if (expression2 == null || !expression2.isValid()) continue;
                PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier(expression2);
                if (!ENTRY_GETTER.test(entryCall)) continue;
                ct.replace((PsiElement)entryCall, (PsiElement)factory.createIdentifier(ParameterCandidate.select((PsiMethodCallExpression)entryCall, (ParameterCandidate)key2, (ParameterCandidate)value2).myName));
            }
            String lambdaBody = body2 instanceof PsiExpression || body2 instanceof PsiCodeBlock || body2 instanceof PsiBlockStatement ? ct.text(body2) : "{" + ct.text(body2) + "}";
            PsiLambdaExpression newLambda = (PsiLambdaExpression)factory.createExpressionFromText("(" + key2.myName + "," + value2.myName + ")->" + lambdaBody, body2);
            LambdaRefactoringUtil.simplifyToExpressionLambda(newLambda);
            entrySetCall.getArgumentList().add((PsiElement)newLambda);
            ExpressionUtils.bindCallTo(entrySetCall, "forEach");
            return ct.text((PsiElement)entrySetCall);
        }

        private static void fixInForeach(PsiForeachStatement loop) {
            PsiMethodCallExpression entrySetCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
            if (entrySetCall == null) {
                return;
            }
            PsiStatement body2 = loop.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameter entryParameter = loop.getIterationParameter();
            CommentTracker ct = new CommentTracker();
            String replacementExpression = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, (PsiElement)body2, ct);
            ct.replaceAndRestoreComments((PsiElement)loop, replacementExpression + ";");
        }

        private static class ParameterCandidate {
            PsiVariable myOriginalVar;
            final PsiType myType;
            String myName;

            public ParameterCandidate(PsiType entryType, boolean isKey) {
                this.myName = isKey ? "key" : "value";
                this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)entryType, (String)Java8MapForEachInspection.JAVA_UTIL_MAP_ENTRY, (int)(isKey ? 0 : 1), (boolean)true));
            }

            private void createName(PsiElement context, CommentTracker ct) {
                if (this.myOriginalVar != null) {
                    this.myName = this.myOriginalVar.getName();
                    ct.delete((PsiElement)this.myOriginalVar);
                } else {
                    this.myName = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestUniqueVariableName(this.myName, context, true);
                }
            }

            public void accept(PsiMethodCallExpression call) {
                if (this.myOriginalVar != null) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
                if (variable != null && EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(variable.getType(), this.myType)) {
                    this.myOriginalVar = variable;
                }
            }

            static ParameterCandidate select(PsiMethodCallExpression entryCall, ParameterCandidate key2, ParameterCandidate value2) {
                String methodName = entryCall.getMethodExpression().getReferenceName();
                return "getKey".equals(methodName) ? key2 : value2;
            }
        }
    }
}

